<?php
session_start();

// Test için session ayarla
$_SESSION['loggedin'] = true;
$_SESSION['username'] = 'aaaa';

echo "<h2>KYC Final Test</h2>";

// Test dosyaları oluştur
$test_content = "Bu bir test KYC dosyasıdır. Test amaçlı oluşturulmuştur.";
file_put_contents('test_kimlik_on.txt', $test_content);
file_put_contents('test_kimlik_arka.txt', $test_content);

// Dosyaları JPG olarak yeniden adlandır
rename('test_kimlik_on.txt', 'test_kimlik_on.jpg');
rename('test_kimlik_arka.txt', 'test_kimlik_arka.jpg');

echo "<p>Test dosyaları oluşturuldu.</p>";

// $_FILES ve $_POST simülasyonu
$_POST['action'] = 'upload_kyc';

$_FILES['kimlik_on'] = [
    'name' => 'test_kimlik_on.jpg',
    'type' => 'image/jpeg',
    'tmp_name' => 'test_kimlik_on.jpg',
    'error' => UPLOAD_ERR_OK,
    'size' => filesize('test_kimlik_on.jpg')
];

$_FILES['kimlik_arka'] = [
    'name' => 'test_kimlik_arka.jpg',
    'type' => 'image/jpeg',
    'tmp_name' => 'test_kimlik_arka.jpg',
    'error' => UPLOAD_ERR_OK,
    'size' => filesize('test_kimlik_arka.jpg')
];

echo "<p>POST ve FILES verileri ayarlandı.</p>";
echo "<p>Kimlik ön dosya boyutu: " . $_FILES['kimlik_on']['size'] . " bytes</p>";
echo "<p>Kimlik arka dosya boyutu: " . $_FILES['kimlik_arka']['size'] . " bytes</p>";

// KYC handler'ı çağır
echo "<h3>KYC Handler Sonucu:</h3>";
ob_start();
include 'kyc_handler.php';
$result = ob_get_clean();

echo "<pre>" . htmlspecialchars($result) . "</pre>";

// Test dosyalarını temizle
if (file_exists('test_kimlik_on.jpg')) unlink('test_kimlik_on.jpg');
if (file_exists('test_kimlik_arka.jpg')) unlink('test_kimlik_arka.jpg');

echo "<p>Test tamamlandı.</p>";
?>