<!DOCTYPE html>
<html>
<head>
    <title>KYC Web Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .form-group { margin: 15px 0; }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        input[type="file"] { margin-bottom: 10px; }
        button { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background: #0056b3; }
        .result { margin-top: 20px; padding: 15px; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>
    <?php
    session_start();
    $_SESSION['loggedin'] = true;
    $_SESSION['username'] = 'aaaa';
    ?>
    
    <h1>KYC Web Test</h1>
    <p><strong>Session Durumu:</strong> <?php echo $_SESSION['loggedin'] ? 'Aktif' : 'Pasif'; ?></p>
    <p><strong>Kullanıcı:</strong> <?php echo $_SESSION['username']; ?></p>
    
    <form id="kycForm" enctype="multipart/form-data">
        <div class="form-group">
            <label for="kimlik_on">Kimlik Ön Yüz:</label>
            <input type="file" id="kimlik_on" name="kimlik_on" accept="image/*" required>
        </div>
        
        <div class="form-group">
            <label for="kimlik_arka">Kimlik Arka Yüz:</label>
            <input type="file" id="kimlik_arka" name="kimlik_arka" accept="image/*" required>
        </div>
        
        <button type="submit">KYC Belgelerini Gönder</button>
    </form>
    
    <div id="result"></div>
    
    <script>
    document.getElementById('kycForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData();
        formData.append('action', 'upload_kyc');
        formData.append('kimlik_on', document.getElementById('kimlik_on').files[0]);
        formData.append('kimlik_arka', document.getElementById('kimlik_arka').files[0]);
        
        const resultDiv = document.getElementById('result');
        resultDiv.innerHTML = '<p>Yükleniyor...</p>';
        
        fetch('./kyc_handler.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                resultDiv.innerHTML = '<div class="result success"><strong>Başarılı!</strong> ' + data.message + '</div>';
            } else {
                resultDiv.innerHTML = '<div class="result error"><strong>Hata!</strong> ' + data.message + '</div>';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            resultDiv.innerHTML = '<div class="result error"><strong>Hata!</strong> Bir hata oluştu: ' + error.message + '</div>';
        });
    });
    </script>
</body>
</html>