<?php
session_start();
include 'inc/database.php';

// Veritabanı bağlantısı
$host = 'localhost';
$db = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

$conn = new mysqli($host, $user, $pass, $db);

// Bağlantı kontrolü
if ($conn->connect_error) {
    die("Bağlantı hatası: " . $conn->connect_error);
}

$message = '';
$alertType = '';
$showForm = false;
$token = '';

// Token kontrolü
if (isset($_GET['token'])) {
    $token = $_GET['token'];
    
    // Token'ı veritabanında ara
    $stmt = $conn->prepare("SELECT id, username, reset_token_expires FROM kullanicilar WHERE reset_token = ?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        $expiry_time = strtotime($user['reset_token_expires']);
        $current_time = time();
        
        if ($current_time <= $expiry_time) {
            $showForm = true;
        } else {
            $message = "Şifre sıfırlama bağlantısının süresi dolmuş. Lütfen yeni bir sıfırlama bağlantısı talep edin.";
            $alertType = "danger";
        }
    } else {
        $message = "Geçersiz şifre sıfırlama bağlantısı.";
        $alertType = "danger";
    }
    
    $stmt->close();
} else {
    $message = "Şifre sıfırlama token'ı bulunamadı.";
    $alertType = "danger";
}

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['token'])) {
    $token = $_POST['token'];
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirm_password'];
    
    // Şifrelerin eşleşip eşleşmediğini kontrol et
    if ($password !== $confirmPassword) {
        $message = "Şifreler eşleşmiyor.";
        $alertType = "danger";
        $showForm = true;
    } 
    // Şifre karmaşıklığını kontrol et
    elseif (!preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).{8,}$/', $password)) {
        $message = "Şifre en az 8 karakter uzunluğunda olmalı ve en az bir büyük harf, bir küçük harf ve bir rakam içermelidir.";
        $alertType = "danger";
        $showForm = true;
    } 
    else {
        // Token'ı veritabanında ara
        $stmt = $conn->prepare("SELECT id FROM kullanicilar WHERE reset_token = ?");
        $stmt->bind_param("s", $token);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            
            // Token geçerlilik süresini kontrol et
            $checkStmt = $conn->prepare("SELECT reset_token_expires FROM kullanicilar WHERE id = ?");
            $checkStmt->bind_param("i", $user['id']);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();
            $tokenData = $checkResult->fetch_assoc();
            $checkStmt->close();
            
            $expiry_time = strtotime($tokenData['reset_token_expires']);
            $current_time = time();
            
            if ($current_time <= $expiry_time) {
                // Şifreyi güncelle
                $passwordHash = password_hash($password, PASSWORD_DEFAULT);
                $updateStmt = $conn->prepare("UPDATE kullanicilar SET password = ?, reset_token = NULL, reset_token_expires = NULL WHERE id = ?");
                $updateStmt->bind_param("si", $passwordHash, $user['id']);
            
            if ($updateStmt->execute()) {
                  $message = "Şifreniz başarıyla sıfırlandı. Artık yeni şifrenizle giriş yapabilirsiniz.";
                  $alertType = "success";
                  $showForm = false;
                  // 3 saniye sonra giriş sayfasına yönlendir
                  header("refresh:3;url=/giris.php");
              } else {
                  $message = "Şifre sıfırlama sırasında bir hata oluştu. Lütfen daha sonra tekrar deneyin.";
                  $alertType = "danger";
                  $showForm = true;
              }
              
              $updateStmt->close();
            } else {
                $message = "Şifre sıfırlama bağlantısının süresi dolmuş. Lütfen yeni bir sıfırlama bağlantısı talep edin.";
                $alertType = "danger";
                $showForm = false;
            }
        } else {
            $message = "Geçersiz veya süresi dolmuş şifre sıfırlama bağlantısı.";
            $alertType = "danger";
            $showForm = false;
        }
        
        $stmt->close();
    }
}

// Bağlantıyı kapat
$conn->close();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Şifre Sıfırlama</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #000;
            color: #fff;
            padding-top: 50px;
        }
        .reset-password-container {
            max-width: 500px;
            margin: 0 auto;
            background-color: #1a1a1a;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .btn-primary {
            background-color: #ffc107;
            border: none;
            width: 100%;
            color: #000;
        }
        .form-control {
            background-color: #333;
            border: 1px solid #444;
            color: #fff;
        }
        .form-control:focus {
            background-color: #444;
            color: #fff;
            border-color: #007bff;
            box-shadow: 0 0 0 0.25rem rgba(0, 123, 255, 0.25);
        }
        .alert {
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="reset-password-container">
            <div class="logo">
                <img src="/assets/images/logo/logo.png" alt="Logo" height="60">
            </div>
            
            <h2 class="text-center mb-4">Şifre Sıfırlama</h2>
            
            <?php if ($message): ?>
                <div class="alert alert-<?php echo $alertType; ?>">
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>
            
            <?php if ($showForm): ?>
                <form method="post" action="">
                    <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                    
                    <div class="mb-3">
                        <label for="password" class="form-label">Yeni Şifre</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                        <div class="form-text text-muted">Şifreniz en az 8 karakter uzunluğunda olmalı ve en az bir büyük harf, bir küçük harf ve bir rakam içermelidir.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Şifreyi Tekrar Girin</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                    </div>
                    
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary">Şifremi Sıfırla</button>
                    </div>
                </form>
            <?php endif; ?>
            
            <div class="text-center mt-3">
                <a href="/" class="text-light">Ana Sayfaya Dön</a>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>