<?php
echo "<h2>Basit KYC Test</h2>";

// Session başlat
session_start();
$_SESSION['loggedin'] = true;
$_SESSION['username'] = 'aaaa';

echo "Session ayarlandı.<br>";

// KYC handler'ı doğrudan test et
echo "<h3>KYC Handler Test</h3>";

// Test için gerekli değişkenleri ayarla
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST['action'] = 'upload_kyc';

// Basit test dosyası oluştur
$test_content = "Test KYC dosyası";
$test_file = __DIR__ . '/test_temp.jpg';
file_put_contents($test_file, $test_content);

$_FILES['kimlik_on'] = [
    'name' => 'test_on.jpg',
    'type' => 'image/jpeg',
    'tmp_name' => $test_file,
    'error' => 0,
    'size' => strlen($test_content)
];

$_FILES['kimlik_arka'] = [
    'name' => 'test_arka.jpg', 
    'type' => 'image/jpeg',
    'tmp_name' => $test_file,
    'error' => 0,
    'size' => strlen($test_content)
];

echo "Test verileri hazırlandı.<br>";
echo "POST action: " . $_POST['action'] . "<br>";
echo "FILES kimlik_on: " . $_FILES['kimlik_on']['name'] . "<br>";

// KYC handler'ı çağır
echo "<h3>Handler Çıktısı:</h3>";
echo "<div style='border:1px solid #ccc; padding:10px; background:#f9f9f9;'>";

// Output buffering ile handler çıktısını yakala
ob_start();
try {
    include './profile/kyc_handler.php';
} catch (Exception $e) {
    echo "Hata: " . $e->getMessage();
}
$handler_output = ob_get_clean();

echo htmlspecialchars($handler_output);
echo "</div>";

// Test dosyasını temizle
if (file_exists($test_file)) {
    unlink($test_file);
    echo "<br>Test dosyası temizlendi.";
}
?>