<?php include './inc/head.php' ?>
<?php include './inc/header.php' ?>
<?php include './inc/slider.php' ?>

<?php
include './database.php';

// Oyunları arama fonksiyonu
function searchGames($searchTerm) {
    global $pdo;
    $sql = "SELECT game_id, game_name, cover FROM games WHERE game_name LIKE :searchTerm";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':searchTerm', '%' . $searchTerm . '%', PDO::PARAM_STR);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Toplam oyun sayısını almak için fonksiyon
function getGameCount() {
    global $pdo;
    $sql = "SELECT COUNT(*) as total_games FROM games";
    $stmt = $pdo->query($sql);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    return $result['total_games'];
}

// Toplam oyun sayısını al
$total_games = getGameCount();
?>

<style>
    .content-offset { height: 102px; }
    @media (max-width: 768px) { .content-offset { height: 90px; } }

    /* Header'ın tam ekrana oturması için */
    body {
        padding-top: 60px !important;
    }

    .headBar {
        position: fixed !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        width: 100% !important;
        z-index: 1000 !important;
    }

    .iframe-popup {
        display: none;
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 80%;
        height: 80%;
        background-color: white;
        border-radius: 10px;
        border: 1px solid #ccc;
        z-index: 9999;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }

    .iframe-popup iframe {
        width: 100%;
        height: 100%;
        border: none;
    }

    .overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.7);
        z-index: 9998;
    }

    .flex-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

.vendor-item {
    display: inline-block;
    margin-right: 8px; /* Elemanlar arasındaki mesafeyi daraltıyoruz */
    text-align: center;
    cursor: pointer;
    transition: transform 0.3s ease, box-shadow 0.3s ease; /* Geçiş animasyonu */
    width: 100px; /* Kutu genişliğini daha da küçültüyoruz */
    height: 90px; /* Kutu yüksekliğini artırarak metin için alan açıyoruz */
    overflow: hidden;
    position: relative;
    color: #000;
    font-size: 12px; /* Metin boyutunu küçültüyoruz */
    border-radius: 8px; /* Yuvarlak kenarları koruyoruz */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Hafif gölge */
    padding: 5px; /* Resmin etrafına iç boşluk */
    background-color: #fff; /* Beyaz arka plan */
    border: none; /* Kenarlıkları kaldırıyoruz */
}

.vendor-item img {
    width: 100%;
    height: 60px;
    object-fit: contain; /* Görselleri kutuya orantılı sığdır */
    border-radius: 6px; /* Resmin kenarlarını yuvarlatıyoruz */
    background: linear-gradient(180deg, rgba(255,255,255,0) 0%, rgba(0,0,0,0.05) 100%);
}

.vendor-item .type {
    display: block;
    margin-top: 5px; /* Başlık için mesafe daraltıldı */
    color: #666; /* Daha yumuşak metin rengi */
    font-weight: bold; /* Metni kalınlaştırıyoruz */
    font-size: 10px; /* Metin boyutunu küçültüyoruz */
}

.vendor-item:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15); /* Hover efektinde gölge büyütülür */
}

.vendor-item.active {
    transform: scale(1.1);
    background-color: rgba(0, 0, 0, 0.6); /* Seçili öğe arka planını koyulaştırıyoruz */
    border-radius: 6px; /* Seçili öğenin kenarlarını yuvarlatıyoruz */
    box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2); /* Seçili öğede daha belirgin gölge */
}

.horizontal-scroll {
    overflow-x: auto;
    white-space: nowrap;
    padding: 10px 0; /* Scroll alanının üst ve alt boşluklarını daraltıyoruz */
}

/* Mobil uyumlu tasarım */
@media (max-width: 768px) {
    body {
        background-color: #000 !important; /* Siyah arka plan */
    }
    
    .vendor-item {
        width: 80px; /* Mobilde kutu genişliğini küçültüyoruz */
        height: 85px; /* Metin için alan açacak şekilde ayarlandı */
        font-size: 9px; /* Metin boyutunu daha da küçültüyoruz */
        padding: 4px; /* İç boşluğu daraltıyoruz */
    }

    .vendor-item img {
        height: 50px; /* Mobilde resim yüksekliği */
    }

    .vendor-item .type {
        font-size: 8px; /* Başlık metnini daha da küçültüyoruz */
        margin-top: 4px; /* Başlık için mesafeyi azaltıyoruz */
    }
    
    .iframe-popup {
        width: 95%;
        height: 90%;
        top: 5%;
        left: 2.5%;
        transform: none;
    }
    
    .horizontal-scroll {
        padding: 5px 0;
    }
    
    .livecasino-search input[type="text"] {
        max-width: 100%;
        font-size: 14px;
    }
    
    /* Button container için mobil stil */
    #slot-button-container {
        background-color: transparent !important;
    }
}

@media (max-width: 575px) {
    .vendor-item {
        width: 70px;
        height: 80px;
        font-size: 8px;
        padding: 3px;
        margin-right: 8px;
    }

    .vendor-item img {
        height: 45px;
    }

    .vendor-item .type {
        font-size: 7px;
        margin-top: 3px;
    }
    
    .iframe-popup {
        width: 98%;
        height: 95%;
        top: 2.5%;
        left: 1%;
    }
    
    .livecasino-search {
        padding: 5px 0;
    }
    
    .livecasino-search input[type="text"] {
        padding: 6px 10px;
        font-size: 13px;
    }
}

@media (max-width: 480px) {
    .vendor-item {
        width: 60px; /* Çok küçük cihazlar için kutu genişliğini küçültüyoruz */
        height: 80px; /* Yüksekliği metin için alan açacak şekilde ayarlıyoruz */
        font-size: 8px; /* Metin boyutunu küçültüyoruz */
        padding: 3px; /* İç boşluğu daha da küçültüyoruz */
        margin-right: 6px;
    }

    .vendor-item img {
        height: 45px; /* Küçük cihazlarda resim yüksekliği */
    }

    .vendor-item .type {
        font-size: 6px; /* Başlık metnini daha da küçültüyoruz */
        margin-top: 3px; /* Başlık için mesafeyi azaltıyoruz */
    }
    
    .iframe-popup {
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        border-radius: 0;
    }
    
    .livecasino-search input[type="text"] {
        padding: 5px 8px;
        font-size: 12px;
    }
}

</style>
<style id="slot-vendor-unify">
:root { --vendor-width: 100px; --vendor-height: 54px; --vendor-img-h: 40px; }
#vendorsList { padding: 8px 12px; }
#vendorsList .vendor-item { width: var(--vendor-width) !important; height: var(--vendor-height) !important; display: inline-flex; flex-direction: column; align-items: center; justify-content: center; gap: 6px; margin-right: 10px; border-radius: 12px; background: rgba(255,255,255,0.06); border: 1px solid rgba(255,255,255,0.08); box-shadow: 0 4px 8px rgba(0,0,0,0.15); }
#vendorsList .vendor-item img { height: var(--vendor-img-h) !important; width: 85% !important; object-fit: contain; filter: none; }
#vendorsList .vendor-item .type { font-size: 9px !important; font-weight: 600; color: rgba(255,255,255,0.85); text-align: center; }
#vendorsList .vendor-item.active { outline: 2px solid var(--login-button-bg); box-shadow: 0 0 0 3px rgba(232,195,76,0.25); background: rgba(255,255,255,0.12); }
@media (max-width: 480px) {
  :root { --vendor-width: 90px; --vendor-height: 50px; --vendor-img-h: 38px; }
}
</style>
<script id="slot-header-offset">
document.addEventListener('DOMContentLoaded', function(){
  try {
    const header = document.querySelector('header.headBar');
    const offsetEl = document.querySelector('.content-offset');
    let headerHeight = header ? header.offsetHeight : 0;
    if (!headerHeight || headerHeight < 50) {
      headerHeight = window.matchMedia('(max-width: 768px)').matches ? 64 : 72;
    }
    if (offsetEl) {
      offsetEl.style.display = 'block';
      offsetEl.style.height = headerHeight + 'px';
    }
  } catch(e) { /* silent */ }
});
</script>

<script>
    // iframe popup'ı açma fonksiyonu
    function openIframe(url) {
        const iframePopup = document.getElementById('iframePopup');
        const overlay = document.getElementById('overlay');
        const iframe = document.getElementById('gameIframe');

        iframe.src = url; // URL'yi iframe'e ayarla
        iframePopup.style.display = 'block'; // Popup'ı göster
        overlay.style.display = 'block'; // Overlay'i göster
    }

    // Popup'ı kapatma fonksiyonu
    function closeIframe() {
        const iframePopup = document.getElementById('iframePopup');
        const overlay = document.getElementById('overlay');
        const iframe = document.getElementById('gameIframe');

        iframe.src = ''; // iframe kaynağını temizle
        iframePopup.style.display = 'none'; // Popup'ı gizle
        overlay.style.display = 'none'; // Overlay'i gizle
    }
</script>

<div class="overlay" id="overlay" onclick="closeIframe()"></div>
<div class="iframe-popup" id="iframePopup">
    <button onclick="closeIframe()" style="position: absolute; top: 10px; right: 10px;">Kapat</button>
    <iframe id="gameIframe" src=""></iframe>
</div>

<div class="horizontal-scroll" id="vendorsList">
	<div class="vendor-item vendorId-0 active" onclick="loadGames('hepsi', this)">
        <img src="./providersimg/hepsi.png" alt="Hepsi" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('other', this)">
        <img src="./providersimg/diger.png" alt="Diğer">
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('pragmatic', this)">
        <img src="./providersimg/pragmatic.png" alt="pragmatic" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('evoplay', this)">
        <img src="./providersimg/evoplay.png" alt="evoplay" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('spribe', this)">
        <img src="./providersimg/spribe.png" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('aviatrix', this)">
        <img src="./providersimg/aviatrix.png" alt="aviatrix" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('egtdigital', this)">
        <img src="./providersimg/egt.png" alt="egtdigital" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('amusnet', this)">
        <img src="./providersimg/amusnet.png" alt="amusnet" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('amigogaming', this)">
        <img src="./providersimg/amigogaming.png" alt="amigogaming" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('netgame', this)">
        <img src="./providersimg/netgame.png" alt="netgame" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('3oaks', this)">
        <img src="./providersimg/3oaks.png" alt="3oaks" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('fazi', this)">
        <img src="./providersimg/fazi.png" alt="fazi" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('habanero', this)">
        <img src="./providersimg/habanero.png" alt="habanero" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('hacksaw', this)">
        <img src="./providersimg/hacksaw.png" alt="hacksaw" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('popok', this)">
        <img src="./providersimg/popok.png" alt="popok" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('platipus', this)">
        <img src="./providersimg/platipus.png" alt="platipus" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('mancala', this)">
        <img src="./providersimg/mancala.png" alt="mancala" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('retrogames', this)">
        <img src="./providersimg/retrogaming.png" alt="retrogames" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('spinomenal', this)">
        <img src="./providersimg/spinomena.png" alt="spinomenal" />
    </div>
   <div class="vendor-item vendorId-156" onclick="loadGames('onetouch', this)">
        <img src="./providersimg/onetouch.png" alt="onetouch" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('spearhead', this)">
        <img src="./providersimg/spearhead.png" alt="spearhead" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('platingaming', this)">
        <img src="./providersimg/platingaming.png" alt="platingaming" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('gamzix', this)">
        <img src="./providersimg/gamzix.png" alt="gamzix" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('redrake', this)">
        <img src="./providersimg/redrake.png" alt="redrake" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('rubyplay', this)">
        <img src="./providersimg/rubyplay.png" alt="rubyplay" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('pateplay', this)">
        <img src="./providersimg/pateplay.png" alt="pateplay" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('kagaming', this)">
        <img src="./providersimg/kagaming.png" alt="kagaming" />
    </div>
	<div class="vendor-item vendorId-156" onclick="loadGames('boominggames', this)">
        <img src="./providersimg/booming.png" alt="boominggames" />
    </div>
    <div class="vendor-item vendorId-156" onclick="loadGames('bgaming', this)">
        <img src="./providersimg/bgaming.png" alt="bgaming" />
    </div>
 </div>

<style id="slot-search-style">
  .slot-search { display: flex; justify-content: flex-end; gap: 8px; padding: 10px 0; }
  .slot-search input[type="text"], .slot-search select { width: 100%; max-width: 380px; padding: 8px 12px; border-radius: 8px; border: 1px solid #D4AF37; background: #1a1a1a; color: #eaeef7; outline: none; font-size: 14px; }
  .slot-search input::placeholder { color: #b8c1d9; }
  .slot-search input:focus { border-color: #D4AF37; box-shadow: 0 0 0 2px rgba(212, 175, 55, 0.2); }
  .slot-search select { max-width: 180px; }
  .slot-search select option { background: #1a1a1a; color: #eaeef7; }
  .loading-spinner { text-align: center; padding: 40px; color: #eaeef7; font-size: 16px; }
  .no-games-message { text-align: center; padding: 40px; color: #b8c1d9; font-size: 16px; }
  @media (max-width: 768px) { .slot-search input[type="text"], .slot-search select { max-width: 100%; font-size: 14px; } }
  @media (max-width: 575px) { .slot-search { padding: 5px 0; } .slot-search input[type="text"], .slot-search select { padding: 6px 10px; font-size: 13px; } }
  @media (max-width: 480px) { .slot-search input[type="text"], .slot-search select { padding: 5px 8px; font-size: 12px; } }
</style>
<div class="slot-search">
    <input type="text" id="slotSearchInput" placeholder="Slot oyunlarında ara..." oninput="window.slotFilterGames(this.value)">
</div>

<script>
(function(){
    let searchTimeout;
    
    async function globalSearchSlots(term) {
        const container = document.getElementById('gamesContainer');
        const q = (term || '').trim();
        
        // Debounce: Önceki timeout'u temizle
        if (searchTimeout) {
            clearTimeout(searchTimeout);
        }
        
        // Arama terimi boşsa veya 2 karakterden azsa, hiçbir işlem yapma
        if (q.length < 2) { return; }
        
        // Loading göster
        if (container) {
            container.innerHTML = '<div class="loading-spinner">Aranıyor...</div>';
        }
        
        searchTimeout = setTimeout(async () => {
            try {
                const response = await fetch(`./games/slot/search_all_slots.php?search=${encodeURIComponent(q)}`);
                if (!response.ok) throw new Error('Network response was not ok');
                
                const data = await response.json();
                
                if (data.success && data.html) {
                    if (container) {
                        container.innerHTML = data.html;
                        // Demo butonlarını enjekte et
                        if (typeof attachDemoButtonsGlobal === 'function') {
                            attachDemoButtonsGlobal();
                        }
                    }
                } else {
                    if (container) {
                        container.innerHTML = '<div class="no-games-message">Arama sonucu bulunamadı.</div>';
                    }
                }
            } catch (error) {
                console.error('Global slot search error:', error);
                if (container) {
                    container.innerHTML = '<div class="no-games-message">Arama sırasında bir hata oluştu.</div>';
                }
            }
        }, 300); // 300ms debounce
    }
    
    window.slotFilterGames = globalSearchSlots;
})();
</script>



<script>
function attachDemoButtonsGlobal() {
    const container = document.getElementById('gamesContainer');
    const scope = container || document;
    const items = scope.querySelectorAll('.game-item');
    items.forEach(item => {
        if (item.querySelector('.btn-demo')) return; // zaten eklenmişse tekrar ekleme
        const gameId = (function(){
            const link = item.querySelector('a[href*="/start/game.php?gameid="]');
            if (link) {
                try {
                    const url = new URL(link.getAttribute('href'), window.location.origin);
                    const id = url.searchParams.get('gameid');
                    if (id) return id;
                } catch(e){}
            }
            const clickable = item.querySelector('[onclick*="/start/game.php?gameid="]') || item;
            if (clickable && clickable.hasAttribute('onclick')) {
                const text = clickable.getAttribute('onclick');
                const m = text.match(/game\.php\?gameid=(\d+)/);
                if (m) return m[1];
            }
            return null;
        })();
        if (!gameId) return;
        let actions = item.querySelector('.game-actions');
        if (!actions) {
            actions = document.createElement('div');
            actions.className = 'game-actions';
    // Global CSS controls .game-actions layout
    actions.style.cssText = '';
            const img = item.querySelector('img');
            if (img && img.parentNode === item) {
                img.insertAdjacentElement('afterend', actions);
            } else {
                item.appendChild(actions);
            }
        }
        const btnReal = document.createElement('button');
        btnReal.className = 'btn-real';
        btnReal.textContent = 'Oyna';
    btnReal.style.cssText = '';
        btnReal.addEventListener('click', () => window.open(`/start/game.php?gameid=${gameId}`, '_blank'));
        const btnDemo = document.createElement('button');
        btnDemo.className = 'btn-demo';
    btnDemo.textContent = 'Demo';
    btnDemo.style.cssText = '';
        btnDemo.addEventListener('click', () => window.open(`/start/game.php?gameid=${gameId}&demo=1`, '_blank'));
        actions.appendChild(btnReal);
        actions.appendChild(btnDemo);
    });
}

function observeAndInjectDemo() {
    const container = document.getElementById('gamesContainer');
    if (!container) return;
    attachDemoButtonsGlobal();
    const observer = new MutationObserver(() => {
        attachDemoButtonsGlobal();
    });
    observer.observe(container, { childList: true, subtree: true });
}

function loadGames(provider, element) {
    // Belirtilen sağlayıcının dosyasını yükle
    const filePath = `./games/casino/${provider}.php?hide_search=1`;

    // Geçerli sağlayıcıyı globalde sakla
    window.currentSlotProvider = provider;

    // Burada PHP dosyasını içeri aktarıyoruz
    fetch(filePath)
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.text();
        })
        .then(data => {
            // Oyunları içeren dosyanın içeriğini yerleştir
            const container = document.getElementById('gamesContainer');
            if (container) {
                container.innerHTML = data; // Burada oyunları göstereceğin bir konteyner olmalı
                // Hepsi.php içinden gelen yerleşik arama barını kaldır
                const innerSearch = container.querySelector('.search-bar');
                if (innerSearch) innerSearch.remove();
            }

            // Seçili öğeyi güncelle
            updateActiveVendor(element);

            // Demo butonlarını enjekte et
            attachDemoButtonsGlobal();

            // Mevcut arama terimine göre filtre uygula
            const input = document.getElementById('slotSearchInput');
            if (input && window.slotFilterGames) window.slotFilterGames(input.value);
        })
        .catch(error => {
            console.error('Error loading the games:', error);
        });
}

function updateActiveVendor(selectedElement) {
    const vendorItems = document.querySelectorAll('.vendor-item');
    
    // Tüm vendor bağlantılarındaki "active" sınıfını kaldır
    vendorItems.forEach(item => {
        item.classList.remove('active');
    });
    
    // Seçilen öğeye "active" sınıfını ekle
    if (selectedElement) {
        selectedElement.classList.add('active');
    }
}

document.addEventListener('DOMContentLoaded', () => {
    observeAndInjectDemo();
    const container = document.getElementById('gamesContainer');
    if (container) {
        // İç arama çubuğunu kaldır, fakat iç "Daha Fazla" butonunu koru
        container.querySelectorAll('.search-bar').forEach(el => el.remove());
    }
    const input = document.getElementById('slotSearchInput');
    if (input && window.slotFilterGames) window.slotFilterGames(input.value);
});
</script>

<style id="slot-grid-override">
#gamesContainer .game-grid {
    display: grid !important;
    grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)) !important;
    grid-gap: 10px !important;
    margin: 10px !important;
}
#gamesContainer .game-item p {
    font-size: 12px !important;
    margin-top: 6px !important;
}
#gamesContainer .game-item img {
    border-radius: 6px !important;
}
</style>

<div id="gamesContainer">
    <?php $hide_search = true; include "./games/casino/hepsi.php"; // Varsayılan olarak "hepsi"yi yükle ?>
</div>

<!-- Global slot-show-more butonu kaldırıldı; iç hepsi.php butonu kullanılacak -->
</div>

<script>
(function(){
    let loadingSlot = false;
    const limitSlot = 20;
    window.slotLoadMoreGames = function(){
        if (loadingSlot) return;
        const btn = document.getElementById('slot-show-more-btn');
        const container = document.getElementById('gamesContainer');
        const grid = container ? container.querySelector('.game-grid') : null;
        const items = grid ? grid.querySelectorAll('.game-item') : [];
        const offsetSlot = items.length; // mevcut eleman sayısı kadar offset
        const searchTerm = (document.getElementById('slotSearchInput')?.value || '').trim();
        const providerGame = (window.currentSlotProvider && window.currentSlotProvider !== 'hepsi') ? window.currentSlotProvider : '';
        // Mevcut sıralamayı koru: sort parametresi göndermiyoruz
        const sortVal = '';
        if (!grid) {
            // Grid yoksa butonu gizle
            const bc = document.getElementById('slot-button-container');
            if (bc) bc.style.display = 'none';
            return;
        }
        loadingSlot = true;
        if (btn) {
            btn.innerText = 'Yükleniyor...';
            btn.disabled = true;
        }
        const url = '/games/casino/loadgames/load_more_games.php?offset=' + offsetSlot + '&limit=' + limitSlot + '&search=' + encodeURIComponent(searchTerm) + (providerGame ? '&provider_game=' + encodeURIComponent(providerGame) : '');
        fetch(url)
            .then(r => {
                if (!r.ok) throw new Error('HTTP ' + r.status);
                return r.json();
            })
            .then(newGames => {
                if (!Array.isArray(newGames) || newGames.length === 0) {
                    alert('Artık daha fazla oyun yok.');
                    return;
                }
                newGames.forEach(game => {
                    const gameItem = document.createElement('div');
                    gameItem.className = 'game-item';
                    gameItem.setAttribute('data-provider', game.provider_game);
                    gameItem.innerHTML = `
                        <img src="${game.cover}" alt="${game.game_name}" onclick="window.open('/start/game.php?gameid=${game.game_id}', '_blank')">
    <div class="game-actions">
        <button class="btn-real" onclick="window.open('/start/game.php?gameid=${game.game_id}', '_blank')">Oyna</button>
        <button class="btn-demo" onclick="window.open('/start/game.php?gameid=${game.game_id}&demo=1', '_blank')">Demo</button>
    </div>
                        <p>${game.game_name}</p>
                    `;
                    grid.appendChild(gameItem);
                });
                // Yeni eklenen elemanlara demo butonu enjekte et
                attachDemoButtonsGlobal();
            })
            .catch(err => {
                console.error('Slot load-more error:', err);
                alert('Oyunları yüklerken bir hata oluştu. Lütfen tekrar deneyin.');
            })
            .finally(() => {
                loadingSlot = false;
                if (btn) {
                    btn.innerText = 'Daha Fazla Oyun Göster';
                    btn.disabled = false;
                }
            });
    };
    // İlk yüklemede içerikten gelen yerleşik butonları kaldır, global butonu göster/gizle
    document.addEventListener('DOMContentLoaded', function(){
        const container = document.getElementById('gamesContainer');
        const grid = container ? container.querySelector('.game-grid') : null;
        const bc = document.getElementById('slot-button-container');
        if (bc) bc.style.display = grid ? '' : 'none';

        // Mobil alt sabit menü yüksekliğine göre ek boşluk ve buton konumu ayarla
        const mobileFooter = document.querySelector('.mobFooter');
        const btn = document.getElementById('slot-show-more-btn');
        function adjustButtonSpacing(){
            const isMobile = window.innerWidth <= 768;
            const footerHeight = (isMobile && mobileFooter) ? mobileFooter.getBoundingClientRect().height : 0;
            if (bc) bc.style.marginBottom = (footerHeight + 140) + 'px';
            if (btn) {
                btn.style.position = 'sticky';
                btn.style.bottom = (footerHeight + 24) + 'px';
                btn.style.zIndex = '1000';
            }
        }
        adjustButtonSpacing();
        window.addEventListener('resize', adjustButtonSpacing);
    });
})();
</script>
</body>
</html>

<script>
(function(){
  async function reorderProvidersByAvailability(listId, basePath){
    const list = document.getElementById(listId);
    if (!list) return;
    const items = Array.from(list.querySelectorAll('.vendor-item'));
    const checks = items.map(async (item) => {
      const onclick = item.getAttribute('onclick') || '';
      const m = onclick.match(/loadGames\(['"]([^'\"]+)['"]\)/);
      const provider = m ? m[1] : null;
      if (!provider) return { item, hasGames: false };
      try {
        const resp = await fetch(`./games/casino/${provider}.php`);
        const text = await resp.text();
        const has = /class=["']game-item["']/.test(text);
        return { item, hasGames: has };
      } catch(e){
        return { item, hasGames: false };
      }
    });
    const results = await Promise.all(checks);
    const fragment = document.createDocumentFragment();
    results.filter(r => r.hasGames).forEach(r => fragment.appendChild(r.item));
    results.filter(r => !r.hasGames).forEach(r => fragment.appendChild(r.item));
    list.innerHTML = '';
    list.appendChild(fragment);
  }
  document.addEventListener('DOMContentLoaded', function(){
    reorderProvidersByAvailability('vendorsList', './games/casino');
  });
})();
</script>