<?php include './inc/head.php'; ?>
<?php include './inc/header.php'; ?>

<?php
// Cihazın mobil olup olmadığını kontrol etme
function isMobile() {
    return preg_match('/(android|iphone|ipod|ipad|mobile)/i', $_SERVER['HTTP_USER_AGENT']);
}
?>

<iframe id="sportIframe" src="<?php echo isMobile() ? '/mobilyenispor' : '/yenispor'; ?>"></iframe>

<style>
iframe {
    width: 100%; /* Tarayıcı genişliğinin %100'ü */
    border: none; /* Çerçeveyi kaldır */
    display: block; /* Varsayılan tarayıcı boşluklarını kaldırmak için */
}

/* Sayfa genelinde header sonrası boşluğu engelle */
body {
    margin: 0 !important;
    padding-top: 0 !important;
}

/* Yükseklik JS ile dinamik ayarlanacak, bu kurallar sadece geçici/fallback içindir */
@media screen and (min-width: 769px) {
    iframe {
        height: auto; /* JS yoksa otomatik yüksekliği kullan */
    }
}

@media screen and (max-width: 768px) {
    iframe {
        height: auto; /* JS yoksa otomatik yüksekliği kullan */
        margin-bottom: 96px; /* Mobil alt sabit menü için güvenli alan */
    }
}
</style>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const iframe = document.getElementById("sportIframe");
    const header = document.querySelector("header.headBar");
    const mobileFooter = document.querySelector(".mobFooter");

    const adjustIframeLayout = () => {
        const windowHeight = window.innerHeight;
        const isMobile = window.innerWidth <= 768;
        const headerHeight = header ? header.getBoundingClientRect().height : 0;
        const footerHeight = (isMobile && mobileFooter) ? mobileFooter.getBoundingClientRect().height : 0;

        // Body'deki olası global padding-top'ı sıfırla (çift boşluk oluşmasın)
        document.body.style.paddingTop = "0px";

        // İçerideki spor uygulamasının ~52px'lik headerını üstteki site headerının altına gizleyerek boşluğu kaldır
        const veritralHeaderHeightMobile = 80; // spor uygulamasındaki mobil header için daha agresif offset
        // İframe’i yukarı kaydırarak içteki spor uygulamasının headerını görünümden çıkar
        const marginTopOffset = headerHeight + (isMobile ? veritralHeaderHeightMobile : 0);
        iframe.style.marginTop = marginTopOffset + "px";
        iframe.style.transform = isMobile ? `translateY(-${veritralHeaderHeightMobile}px)` : "none";
        iframe.style.willChange = "transform";
        
        // Yüksekliği viewporttan header ve (varsa) mobil footer çıkarılarak ayarla; mobilde crop telafisi için ek yükseklik ver
        const baseHeight = Math.max(0, windowHeight - headerHeight - footerHeight);
        iframe.style.height = (isMobile ? baseHeight + veritralHeaderHeightMobile : baseHeight) + "px";

        // Mobilde sabit footer ile çakışmayı önlemek için alt güvenli alan ekle
        iframe.style.marginBottom = isMobile && mobileFooter ? (footerHeight + 16) + "px" : "0px";
    };

    adjustIframeLayout(); // Sayfa yüklendiğinde ayarla
    window.addEventListener("resize", adjustIframeLayout); // Pencere boyutu değiştikçe ayarla
});
</script>
