
<?php
session_start();
include '../database.php'; 
require '../vendor/autoload.php';

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

$game_id = $_GET['gameid'] ?? null;
$mode = $_GET['mode'] ?? '';
$demo = $_GET['demo'] ?? '0';
// demo=1 veya mode=fun gelirse sağlayıcıya 'fun', aksi halde 'real' gönder
$playMode = ($demo === '1' || $mode === 'fun') ? 'fun' : 'real';

// Misafir erişimi: demo ve fun modlarında login zorunlu değil, yalnızca real modda zorunlu
if ($playMode === 'real') {
    if (!isset($_SESSION['username'])) {
        $_SESSION['error_message'] = "Lütfen giriş yapın.";
        header("Location: /");
        exit();
    }
}

if (empty($game_id)) {
    echo '<div style="padding:15px; background:#f44336; color:white;">Sağlayıcı tarafından bakım mevcut</div>';
    exit();
}

try {
    // Demo ve fun modlarında daima misafir kimliği kullan
    if ($playMode === 'demo' || $playMode === 'fun') {
        $username  = 'guest';
        $user_id   = 0;
        $apicdn_id = 0;
        $email     = 'guest@example.com';
        $balance   = 10000;
        $player_id = 'guest_'.uniqid();
    } else {
        // Gerçek veya fun modunda oturumdaki kullanıcıyı kullan
        $username = $_SESSION['username'];

        // Kullanıcı bilgilerini al
        $stmt = $pdo->prepare("SELECT id, username, apicdn_id, email, ana_bakiye FROM kullanicilar WHERE username = :username");
        $stmt->execute(['username' => $username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            echo '<div style="padding:15px; background:#f44336; color:white;">Kullanıcı bulunamadı.</div>';
            exit();
        }

        // Kullanıcı bilgileri
        $user_id    = $user['id'];
        $apicdn_id  = $user['apicdn_id'];
        $email      = $user['email'];
        $balance    = $user['ana_bakiye'] ?? 10000; // default test bakiye
        $player_id  = $user_id; // Player ID olarak veritabanı id kullanıyoruz
        $username   = $user['username'];
    }

    // API verisi
    $data = [
        "api_key"    => "api_68df7464c7bc9_9aae3eaa0228a0a7",
        "secret_key" => "secret_13ea3a59fc49f44584caab9e40ad3971",
        "username"   => $username,
        "player_id"  => (string)$player_id,
        "game_id"    => $game_id,
        "mode"       => $playMode,
        "currency"   => "TRY",
        "language"   => "tr"
    ];

    // Basit log: demo/real/fun açılışları ve kimlikler
    @file_put_contents(__DIR__.'/launch_log.txt', date('c')." LAUNCH mode={$playMode} username={$username} player_id={$player_id} game_id={$game_id}".PHP_EOL, FILE_APPEND);

    $client = new Client();
    $response = $client->request('POST', 'https://api.veritral.com/api/v2/launch', [
        'headers' => ['Content-Type' => 'application/json'],
        'body'    => json_encode($data)
    ]);

    $result = json_decode($response->getBody(), true);

    if (isset($result['status']) && $result['status'] === 'success' && isset($result['data']['launch_url'])) {
        // Dönen URL’i logla (mode parametresini doğrulamak için)
        @file_put_contents(__DIR__.'/launch_log.txt', date('c')." RETURNED launch_url=".($result['data']['launch_url'] ?? '').PHP_EOL, FILE_APPEND);
        header('Location: ' . $result['data']['launch_url']);
        exit();
    } else {
        // Başarısız yanıtı ayrıntılı logla (gizli anahtarları loglamıyoruz)
        @file_put_contents(__DIR__.'/launch_log.txt', date('c')." ERROR mode={$playMode} username={$username} player_id={$player_id} game_id={$game_id} response=".json_encode($result, JSON_UNESCAPED_UNICODE).PHP_EOL, FILE_APPEND);
        $error_message = $result['message'] ?? 'Oyun başlatılamadı.';
        echo "<div style='padding:15px; background:#f44336; color:white;'>$error_message</div>";
        exit();
    }

} catch (RequestException $e) {
    $errorDetails = $e->hasResponse() ? $e->getResponse()->getBody()->getContents() : $e->getMessage();
    echo "<div style='padding:15px; background:#f44336; color:white;'>
            <strong>API Bağlantı Hatası:</strong><br>$errorDetails
          </div>";
    exit();
} catch (Exception $e) {
    echo "<div style='padding:15px; background:#f44336; color:white;'>
            <strong>Hata:</strong> " . htmlspecialchars($e->getMessage()) . "
          </div>";
    exit();
}
?>
