<?php
// Test the bonus API directly
session_start();
$_SESSION['admin_id'] = 1; // Mock admin session

// Include the bonus system API
ob_start();
include 'api/bonus_system.php';
$output = ob_get_clean();

// Parse the JSON response
$response = json_decode($output, true);

echo "<h2>API Test Results</h2>";
echo "<p>Raw Output: " . htmlspecialchars($output) . "</p>";

if ($response) {
    echo "<h3>Parsed Response:</h3>";
    echo "<pre>" . print_r($response, true) . "</pre>";
    
    if (isset($response['success'])) {
        echo "<p>Success: " . ($response['success'] ? 'Yes' : 'No') . "</p>";
        if (isset($response['bonuses'])) {
            echo "<p>Bonuses count: " . count($response['bonuses']) . "</p>";
        }
        if (isset($response['debug'])) {
            echo "<h3>Debug Info:</h3>";
            echo "<pre>" . print_r($response['debug'], true) . "</pre>";
        }
    }
} else {
    echo "<p style='color: red;'>Failed to parse JSON response</p>";
}
?>