<?php
// Test the bonus API directly with proper session setup
session_start();

// Mock session data for testing
$_SESSION['user_id'] = 1;
$_SESSION['admin_id'] = 1;

// Capture the API response
ob_start();

// Simulate the API call
$_GET['action'] = 'admin_get_bonuses';
$_GET['status'] = '';

// Include the API file
include 'api/bonus_system.php';

$output = ob_get_clean();

// Display the results
echo "<h2>API Test Results</h2>";
echo "<p><strong>Raw Output:</strong></p>";
echo "<pre style='background: #f0f0f0; padding: 10px; overflow: auto;'>" . htmlspecialchars($output) . "</pre>";

// Parse the JSON response
$response = json_decode($output, true);

echo "<h2>Parsed Response:</h2>";
if ($response) {
    echo "<p>Success: " . ($response['success'] ? '<span style="color: green;">Yes</span>' : '<span style="color: red;">No</span>') . "</p>";
    
    if (isset($response['message'])) {
        echo "<p>Message: " . htmlspecialchars($response['message']) . "</p>";
    }
    
    if (isset($response['bonuses'])) {
        echo "<p>Bonuses count: <strong>" . count($response['bonuses']) . "</strong></p>";
        
        if (count($response['bonuses']) > 0) {
            echo "<h3>First Bonus:</h3>";
            echo "<pre>" . print_r($response['bonuses'][0], true) . "</pre>";
        }
    }
    
    if (isset($response['debug'])) {
        echo "<h3>Debug Info:</h3>";
        echo "<pre>" . print_r($response['debug'], true) . "</pre>";
    }
} else {
    echo "<p style='color: red;'>Failed to parse JSON response</p>";
}

echo "<hr>";
echo "<h2>Session Info:</h2>";
echo "<pre>" . print_r($_SESSION, true) . "</pre>";

echo "<h2>GET Parameters:</h2>";
echo "<pre>" . print_r($_GET, true) . "</pre>";
?>