<?php
// Test dosyası - bonus sorgusunu kontrol et
include 'config.php';

try {
    echo "=== BONUS SORGUSU TESTI ===\n\n";
    
    // 1. Tablolar var mı kontrol et
    echo "1. Tablo kontrolü:\n";
    $tables = ['personalized_bonuses', 'bonus_talepleri', 'kullanicilar', 'bonus_types'];
    foreach ($tables as $table) {
        $stmt = $db->query("SHOW TABLES LIKE '$table'");
        $exists = $stmt->fetch() ? 'VAR' : 'YOK';
        echo "   $table: $exists\n";
    }
    
    echo "\n2. Tablo verileri:\n";
    
    // personalized_bonuses kontrolü
    $stmt = $db->query("SELECT COUNT(*) as count FROM personalized_bonuses");
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "   personalized_bonuses kayıt sayısı: " . $count['count'] . "\n";
    
    // bonus_talepleri kontrolü  
    $stmt = $db->query("SELECT COUNT(*) as count FROM bonus_talepleri");
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "   bonus_talepleri kayıt sayısı: " . $count['count'] . "\n";
    
    // kullanicilar kontrolü
    $stmt = $db->query("SELECT COUNT(*) as count FROM kullanicilar");
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "   kullanicilar kayıt sayısı: " . $count['count'] . "\n";
    
    echo "\n3. UNION Sorgusu Testi:\n";
    $unionSql = "(SELECT 
                    pb.id, 
                    pb.user_id, 
                    k.username, 
                    bt.name as bonus_name, 
                    pb.amount, 
                    pb.status, 
                    pb.created_at,
                    'personalized' as source_type,
                    pb.bonus_type_id,
                    NULL as request_status
                FROM personalized_bonuses pb 
                LEFT JOIN kullanicilar k ON pb.user_id = k.id 
                LEFT JOIN bonus_types bt ON pb.bonus_type_id = bt.id)
                UNION ALL
                (SELECT 
                    btalep.id, 
                    btalep.uye_id as user_id, 
                    k.username, 
                    btalep.bonus_turu as bonus_name, 
                    btalep.miktar as amount, 
                    CASE btalep.durum 
                        WHEN 0 THEN 'pending' 
                        WHEN 1 THEN 'approved' 
                        WHEN 2 THEN 'rejected' 
                    END as status, 
                    btalep.tarih as created_at,
                    'request' as source_type,
                    NULL as bonus_type_id,
                    btalep.durum as request_status
                FROM bonus_talepleri btalep
                LEFT JOIN kullanicilar k ON btalep.uye_id = k.id)
                ORDER BY created_at DESC LIMIT 10";
    
    $stmt = $db->query($unionSql);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "   UNION sorgu sonucu: " . count($results) . " kayıt bulundu\n";
    
    if (count($results) > 0) {
        echo "\n4. İlk 3 kayıt:\n";
        for ($i = 0; $i < min(3, count($results)); $i++) {
            $row = $results[$i];
            echo "   Kayıt " . ($i+1) . ":\n";
            echo "     ID: " . $row['id'] . "\n";
            echo "     Kullanıcı: " . $row['username'] . "\n";
            echo "     Bonus: " . $row['bonus_name'] . "\n";
            echo "     Miktar: " . $row['amount'] . "\n";
            echo "     Durum: " . $row['status'] . "\n";
            echo "     Kaynak: " . $row['source_type'] . "\n";
            echo "     Tarih: " . $row['created_at'] . "\n\n";
        }
    }
    
    echo "=== TEST TAMAMLANDI ===\n";
    
} catch (PDOException $e) {
    echo "HATA: " . $e->getMessage() . "\n";
}