<?php
// Test verileri
$test_data = array(
    "status" => "confirmed", // "confirmed" veya "declined" olarak test edebilirsiniz
    "amount" => 100.00,
    "username" => "test123",
    "userid" => 268, // Veritabanınızdaki gerçek bir kullanıcı ID'si kullanın
    "type" => "deposit",
    "customer_transaction_id" => "TEST_" . uniqid()
);

// Token oluştur
$token = sha1(md5($test_data['status'].$test_data['amount'].$test_data['userid'].$test_data['customer_transaction_id']));
$test_data['token'] = $token;

// cURL isteği oluştur
$ch = curl_init();

// cURL ayarları
curl_setopt_array($ch, array(
    CURLOPT_URL => "https://Veritral109.com/api/valepays.php", // valepays.php'nin tam URL'sini girin
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($test_data),
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json'
    )
));

// İsteği gönder ve yanıtı al
$response = curl_exec($ch);

// cURL hata kontrolü
if(curl_errno($ch)) {
    echo "cURL Error: " . curl_error($ch);
} else {
    echo "<h2>Gönderilen Veri:</h2>";
    echo "<pre>";
    print_r($test_data);
    echo "</pre>";

    echo "<h2>Alınan Yanıt:</h2>";
    echo "<pre>";
    $decoded_response = json_decode($response, true);
    print_r($decoded_response);
    echo "</pre>";

    // Yanıt durumunu kontrol et
    if(isset($decoded_response['status'])) {
        echo "<h2>Sonuç:</h2>";
        switch($decoded_response['status']) {
            case '200':
                echo "İşlem başarılı!";
                break;
            case '300':
                echo "Bu callback daha önce işlenmiş.";
                break;
            case '301':
                echo "Token hatası!";
                break;
            case '302':
                echo "Geçersiz transaction_id veya durum!";
                break;
            case '303':
                echo "Eksik veri!";
                break;
            case '500':
                echo "Sunucu hatası!";
                break;
            default:
                echo "Bilinmeyen yanıt kodu!";
        }
    }
}

curl_close($ch);

// Test sonuçlarını veritabanından kontrol et
try {
    $host = 'localhost';
    $dbname = 'blacrhdy_bet1';
    $user = 'blacrhdy_bet1';
    $pass = 'blacrhdy_bet1';

    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "<h2>Veritabanı Kontrolleri:</h2>";

    // Payment callbacks tablosunu kontrol et
    $stmt = $pdo->prepare("SELECT * FROM payment_callbacks WHERE transaction_id = ?");
    $stmt->execute([$test_data['customer_transaction_id']]);
    echo "<h3>Payment Callbacks Kaydı:</h3>";
    echo "<pre>";
    print_r($stmt->fetch(PDO::FETCH_ASSOC));
    echo "</pre>";

    // Transaction history tablosunu kontrol et
    $stmt = $pdo->prepare("SELECT * FROM transaction_history WHERE transaction_id = ?");
    $stmt->execute([$test_data['customer_transaction_id']]);
    echo "<h3>Transaction History Kaydı:</h3>";
    echo "<pre>";
    print_r($stmt->fetch(PDO::FETCH_ASSOC));
    echo "</pre>";

    // Kullanıcı bakiyesini kontrol et
    $stmt = $pdo->prepare("SELECT id, username, ana_bakiye FROM kullanicilar WHERE id = ?");
    $stmt->execute([$test_data['userid']]);
    echo "<h3>Kullanıcı Bakiye Bilgisi:</h3>";
    echo "<pre>";
    print_r($stmt->fetch(PDO::FETCH_ASSOC));
    echo "</pre>";

} catch(PDOException $e) {
    echo "Veritabanı Hatası: " . $e->getMessage();
}
?>

<style>
body {
    font-family: Arial, sans-serif;
    margin: 20px;
    line-height: 1.6;
}

h2 {
    color: #333;
    border-bottom: 2px solid #eee;
    padding-bottom: 5px;
    margin-top: 20px;
}

h3 {
    color: #666;
    margin-top: 15px;
}

pre {
    background: #f5f5f5;
    padding: 10px;
    border-radius: 5px;
    overflow-x: auto;
}
</style> 