<?php
session_start();

// Test için session ayarla
$_SESSION['loggedin'] = true;
$_SESSION['username'] = 'aaaa';

echo "<h2>KYC Test Sonuçları</h2>";
echo "Session Durumu:<br>";
echo "- loggedin: " . ($_SESSION['loggedin'] ? 'true' : 'false') . "<br>";
echo "- username: " . $_SESSION['username'] . "<br><br>";

// Test dosyası oluştur (gerçek bir resim dosyası simülasyonu)
$test_image_content = base64_decode('/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/2wBDAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/wAARCAABAAEDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAv/xAAUEAEAAAAAAAAAAAAAAAAAAAAA/8QAFQEBAQAAAAAAAAAAAAAAAAAAAAX/xAAUEQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIRAxEAPwA/8A');

$test_file_path = __DIR__ . '/profile/test_kimlik.jpg';
file_put_contents($test_file_path, $test_image_content);

echo "Test dosyası oluşturuldu: " . $test_file_path . "<br>";
echo "Dosya boyutu: " . filesize($test_file_path) . " bytes<br><br>";

// KYC upload test
echo "<h3>KYC Upload Test</h3>";

// POST ve FILES verilerini ayarla
$_POST['action'] = 'upload_kyc';
$_FILES['kimlik_on'] = [
    'name' => 'test_kimlik_on.jpg',
    'type' => 'image/jpeg',
    'tmp_name' => $test_file_path,
    'error' => 0,
    'size' => filesize($test_file_path)
];
$_FILES['kimlik_arka'] = [
    'name' => 'test_kimlik_arka.jpg',
    'type' => 'image/jpeg',
    'tmp_name' => $test_file_path,
    'error' => 0,
    'size' => filesize($test_file_path)
];

echo "POST ve FILES verileri ayarlandı.<br>";
echo "Action: " . $_POST['action'] . "<br>";
echo "Kimlik ön dosya: " . $_FILES['kimlik_on']['name'] . "<br>";
echo "Kimlik arka dosya: " . $_FILES['kimlik_arka']['name'] . "<br><br>";

// KYC handler'ı çağır
echo "<h3>KYC Handler Çıktısı:</h3>";
ob_start();
include './profile/kyc_handler.php';
$output = ob_get_clean();

echo "<pre style='background:#f0f0f0; padding:10px; border:1px solid #ccc;'>";
echo htmlspecialchars($output);
echo "</pre>";

// Test dosyasını temizle
unlink($test_file_path);
echo "<br>Test dosyası temizlendi.";
?>