<?php
session_start();
require_once __DIR__ . '/inc/database.php';

echo "<h1>Logout Test Sayfası</h1>";

// Mevcut session bilgilerini göster
echo "<h2>Mevcut Session Bilgileri:</h2>";
echo "<pre>";
echo "PHP Session ID: " . session_id() . "\n";
echo "DB Session ID: " . ($_SESSION['db_session_id'] ?? 'Yok') . "\n";
echo "User ID: " . ($_SESSION['user_id'] ?? 'Yok') . "\n";
echo "Username: " . ($_SESSION['username'] ?? 'Yok') . "\n";
echo "</pre>";

// Veritabanındaki aktif sessionları göster
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];
    $stmt = $conn->prepare("SELECT session_id, ip_address, login_time, is_active FROM user_sessions WHERE user_id = ? ORDER BY login_time DESC LIMIT 5");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    echo "<h2>Veritabanındaki Son 5 Session:</h2>";
    echo "<table border='1'>";
    echo "<tr><th>Session ID</th><th>IP</th><th>Login Time</th><th>Active</th></tr>";
    while ($row = $result->fetch_assoc()) {
        $active_text = $row['is_active'] ? 'Evet' : 'Hayır';
        $current = ($_SESSION['db_session_id'] ?? '') === $row['session_id'] ? ' (Mevcut)' : '';
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['session_id']) . $current . "</td>";
        echo "<td>" . htmlspecialchars($row['ip_address']) . "</td>";
        echo "<td>" . htmlspecialchars($row['login_time']) . "</td>";
        echo "<td>" . $active_text . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<br><br>";
echo "<a href='/logout.php'>Logout Yap</a> | ";
echo "<a href='/'>Ana Sayfa</a> | ";
echo "<a href='/session_management.php'>Session Management</a>";
?>