<?php
// Session oluşturma testı
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Session Oluşturma Testi</h2>";

try {
    require_once __DIR__ . '/api/session_management.php';
    
    echo "<p>session_management.php dosyası başarıyla yüklendi.</p>";
    
    // Test kullanıcısı için session oluştur
    $user_id = 282; // aaaa kullanıcısı
    $session_id = createUserSession($user_id, 'web');
    
    if ($session_id) {
        echo "<p style='color: green;'>✅ Session başarıyla oluşturuldu: $session_id</p>";
        
        // Veritabanından kontrol et
        $stmt = $conn->prepare("SELECT * FROM user_sessions WHERE session_id = ? AND user_id = ?");
        $stmt->bind_param("si", $session_id, $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $session_data = $result->fetch_assoc();
            echo "<p style='color: green;'>✅ Session veritabanında bulundu:</p>";
            echo "<pre>" . print_r($session_data, true) . "</pre>";
        } else {
            echo "<p style='color: red;'>❌ Session veritabanında bulunamadı!</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ Session oluşturulamadı!</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
    echo "<p>Stack trace:</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>