<?php
require_once 'woohdd/config.php'; // Woohdd config dosyasını kullan
require_once 'inc/SuspiciousActivityDetector.php';

echo "<h2>Şüpheli Aktivite Tespit Sistemi Test</h2>";

// Test kullanıcısı ID'si (gerçek bir kullanıcı ID'si kullanın)
$test_user_id = 1;

try {
    $detector = new SuspiciousActivityDetector($pdo);
    
    echo "<h3>Test Sonuçları:</h3>";
    
    // 1. Çoklu giriş denemesi testi
    echo "<h4>1. Çoklu Giriş Denemesi Testi</h4>";
    $result1 = $detector->checkMultipleLoginAttempts($test_user_id);
    echo "Sonuç: " . ($result1 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // 2. Farklı lokasyon testi
    echo "<h4>2. Farklı Lokasyon Testi</h4>";
    $result2 = $detector->checkDifferentLoginLocations($test_user_id);
    echo "Sonuç: " . ($result2 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // 3. Hızlı bahis testi
    echo "<h4>3. Hızlı Bahis Testi</h4>";
    $result3 = $detector->checkRapidBetting($test_user_id);
    echo "Sonuç: " . ($result3 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // 4. Anormal kazanç testi
    echo "<h4>4. Anormal Kazanç Testi</h4>";
    $result4 = $detector->checkUnusualWinnings($test_user_id);
    echo "Sonuç: " . ($result4 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // 5. Büyük para yatırma testi
    echo "<h4>5. Büyük Para Yatırma Testi</h4>";
    $result5 = $detector->checkLargeDeposits($test_user_id);
    echo "Sonuç: " . ($result5 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // 6. Büyük para çekme testi
    echo "<h4>6. Büyük Para Çekme Testi</h4>";
    $result6 = $detector->checkLargeWithdrawals($test_user_id);
    echo "Sonuç: " . ($result6 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // 7. Cihaz değişikliği testi
    echo "<h4>7. Cihaz Değişikliği Testi</h4>";
    $result7 = $detector->checkDeviceChange($test_user_id);
    echo "Sonuç: " . ($result7 ? "Şüpheli aktivite tespit edildi" : "Normal") . "<br>";
    
    // Tüm kontrolleri çalıştır
    echo "<h4>8. Tüm Kontroller</h4>";
    $all_results = $detector->runAllChecks($test_user_id);
    echo "Toplam tespit edilen şüpheli aktivite sayısı: " . count($all_results) . "<br>";
    
    if (!empty($all_results)) {
        echo "<h5>Tespit Edilen Aktiviteler:</h5>";
        foreach ($all_results as $activity) {
            echo "- " . $activity['rule_name'] . " (Risk: " . $activity['risk_level'] . ")<br>";
        }
    }
    
    // Veritabanındaki uyarı kurallarını kontrol et
    echo "<h3>Veritabanı Durumu:</h3>";
    
    $rules_stmt = $pdo->query("SELECT COUNT(*) as count FROM alert_rules WHERE is_active = 1");
    $rules_count = $rules_stmt->fetch()['count'];
    echo "Aktif uyarı kuralı sayısı: " . $rules_count . "<br>";
    
    $alerts_stmt = $pdo->query("SELECT COUNT(*) as count FROM detected_suspicious_activities WHERE created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)");
    $alerts_count = $alerts_stmt->fetch()['count'];
    echo "Son 24 saatteki uyarı sayısı: " . $alerts_count . "<br>";
    
    // Son uyarıları göster
    $recent_alerts = $pdo->query("
        SELECT dsa.*, ar.rule_name, u.kullanici_adi 
        FROM detected_suspicious_activities dsa
        JOIN alert_rules ar ON dsa.rule_id = ar.id
        JOIN kullanicilar u ON dsa.user_id = u.id
        ORDER BY dsa.created_at DESC 
        LIMIT 5
    ");
    
    echo "<h4>Son 5 Uyarı:</h4>";
    while ($alert = $recent_alerts->fetch()) {
        echo "- " . $alert['kullanici_adi'] . ": " . $alert['rule_name'] . 
             " (Risk: " . $alert['risk_level'] . ", Durum: " . $alert['status'] . 
             ", Tarih: " . $alert['created_at'] . ")<br>";
    }
    
} catch (Exception $e) {
    echo "<div style='color: red;'>Hata: " . $e->getMessage() . "</div>";
    echo "<div style='color: red;'>Detay: " . $e->getTraceAsString() . "</div>";
}

echo "<br><a href='woohdd/suspicious_alerts.php'>Admin Paneline Git</a>";
?>