<?php
// Veritabanına bağlantı
$dsn = "mysql:host=localhost;dbname=blacrhdy_bet1;charset=utf8mb4";
$username = "blacrhdy_bet1";
$password = "blacrhdy_bet1";

try {
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Veritabanına bağlanılamadı: " . $e->getMessage());
}

// Sağlayıcıları dinamik olarak listeleme
$query = "SELECT DISTINCT provider_game FROM games";
$stmt = $pdo->prepare($query);
$stmt->execute();
$providers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Oyun Sağlayıcıları</title>
    <style>
        .provider-button {
            padding: 10px 15px;
            margin: 5px;
            background-color: #3498db;
            color: white;
            border: none;
            cursor: pointer;
        }
        #games {
            display: grid;
            grid-template-columns: repeat(6, 1fr);
            gap: 20px;
            margin-top: 20px;
        }
        .game-card {
            text-align: center;
        }
        .game-card img {
            width: 100%;
            height: auto;
            max-width: 150px;
            border-radius: 10px;
        }
        .game-card h3 {
            font-size: 1em;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <h1>Oyun Sağlayıcıları</h1>
    <div id="providers">
        <?php foreach ($providers as $provider): ?>
            <button class="provider-button" onclick="loadGames('<?php echo $provider['provider_game']; ?>')">
                <?php echo htmlspecialchars($provider['provider_game']); ?>
            </button>
        <?php endforeach; ?>
    </div>

    <div id="games">
        <!-- Oyunlar buraya yüklenecek -->
    </div>

    <script>
        function loadGames(provider) {
            const xhr = new XMLHttpRequest();
            xhr.open("GET", "testload.php?provider=" + provider, true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    document.getElementById("games").innerHTML = xhr.responseText;
                }
            };
            xhr.send();
        }

        // Başlangıçta ilk sağlayıcı için 50 oyun yüklensin
        if (document.querySelector('.provider-button')) {
            const firstProvider = document.querySelector('.provider-button').getAttribute('onclick').match(/'([^']+)'/)[1];
            loadGames(firstProvider);
        }
    </script>
</body>
</html>
