<?php
// Veritabanına bağlantı
$dsn = "mysql:host=localhost;dbname=blacrhdy_bet1;charset=utf8mb4";
$username = "blacrhdy_bet1";
$password = "blacrhdy_bet1";

try {
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Veritabanına bağlanılamadı: " . $e->getMessage());
}

// Gelen sağlayıcı bilgisi
$provider = isset($_GET['provider']) ? $_GET['provider'] : '';

if ($provider) {
    // Sağlayıcıya göre ilk 50 oyunu getirme
    $query = "SELECT game_name, cover FROM games WHERE provider_game = :provider LIMIT 50";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':provider', $provider, PDO::PARAM_STR);
    $stmt->execute();
    $games = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($games) {
        foreach ($games as $game) {
            echo "<div class='game-card'>";
            echo "<img src='" . htmlspecialchars($game['cover']) . "' alt='" . htmlspecialchars($game['game_name']) . "'>";
            echo "<h3>" . htmlspecialchars($game['game_name']) . "</h3>";
            echo "</div>";
        }
    } else {
        echo "<p>Bu sağlayıcı için oyun bulunamadı.</p>";
    }
} else {
    echo "<p>Sağlayıcı bilgisi eksik.</p>";
}
?>
