<?php
    session_start();
    require_once __DIR__ . '/api/telegram.php';
    $host = 'localhost';
    $dbname = 'blacrhdy_bet1';
    $user = 'blacrhdy_bet1';
    $pass = 'blacrhdy_bet1';

    $secret = 'mdbpbh91b9i15dde9beee974musGBErKDBItrvCew6yaEMGhnC'; // API'den alınan secret key

    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (PDOException $e) {
        error_log('Connection failed: ' . $e->getMessage());
        exit();
    }

    // Kullanıcı bilgilerini al
    $username = $_SESSION['username'];

    try {
        $stmt = $pdo->prepare("SELECT id, first_name, surname, username, ana_bakiye FROM kullanicilar WHERE username = :username");
        $stmt->execute(['username' => $username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            echo json_encode(array("error" => "User not found"));
            exit();
        }
    } catch (PDOException $e) {
        error_log('Query failed: ' . $e->getMessage());
        echo json_encode(array("error" => "Database query failed"));
        exit();
    }

    // API URL'sini tanımla - sadece havale için
    $api_url = 'https://lyizbet.vldbfire.pro/withdraw/with-havale';

    // Form görüntüleme
    $method = 'havale';
    $method_names = ['havale' => 'Banka Havalesi'];
    $wallet_label = 'IBAN';
    $input_pattern = '^[0-9]{24}$'; // Sadece 24 rakam
    $input_maxlength = '24';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $amount = $_POST['amount'];
        $wallet_id = $_POST['wallet_id'];
        $blockchain = isset($_POST['blockchain']) ? $_POST['blockchain'] : null;

        // Minimum tutar kontrolü
        if ($amount < 100) {
            echo json_encode(['status' => 'error', 'message' => 'Minimum para çekme tutarı 100 TL\'dir.']);
            exit();
        }

        // Bakiye kontrolü
        if ($amount > $user['ana_bakiye']) {
            echo json_encode(['status' => 'error', 'message' => 'Yetersiz bakiye.']);
            exit();
        }

        // Transaction ID oluştur (API formatına uygun)
        $transaction_id = 'WT_' . time() . '_' . rand(1000, 9999);

        // Security hash oluştur
        $customername = $user['first_name'].' '.$user['surname'];
        $enchash = sha1(md5($username.$customername.$user['id'].$transaction_id.$amount.$secret));

        // Temel veri yapısı
        $data = array(
            "secret" => $secret,
            "transaction_id" => $transaction_id,
            "amount" => (int)$amount,
            "username" => $username,
            "customername" => $customername,
            "customerid" => (string)$user['id'],
            "enchash" => $enchash
        );

        // İşlem türüne göre özel alanları ekle
        switch('<?= $method ?>') {
            case 'havale':
                // IBAN formatını düzelt
                $iban = preg_replace('/[^0-9]/', '', $wallet_id); // Sadece rakamları al
                if (strlen($iban) === 24) {
                    $data['wallet-id'] = 'TR' . $iban;
                }
                break;
        }

        // Debug için gönderilen veriyi logla
        error_log('API Request Data for ' . $method . ': ' . json_encode($data));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $api_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Accept: application/json'
            ),
        ));

        $response = curl_exec($curl);
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        // Debug için yanıtı logla
        error_log('API Response: ' . $response);

        if ($curl_error = curl_error($curl)) {
            error_log('Curl Error: ' . $curl_error);
        }

        curl_close($curl);

        $result = json_decode($response, true);

        // API yanıtını işle
        if ($result['status'] === '200') {
            try {
                $pdo->beginTransaction();
                
                // Bakiyeyi güncelle
                $stmt = $pdo->prepare("UPDATE kullanicilar SET ana_bakiye = ana_bakiye - ? WHERE id = ?");
                $stmt->execute([$amount, $user['id']]);

                // İşlem geçmişini kaydet
                $stmt = $pdo->prepare("INSERT INTO transaction_history (user_id, amount, type, status, transaction_id, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
                $stmt->execute([$user['id'], $amount, 'withdraw', 'pending', $transaction_id]);

                $pdo->commit();
                
                // Telegram bildirimi
                $chat = getenv('TELEGRAM_CHAT_ID') ?: '@BLACKBETDESTEK';
                $time = date('Y-m-d H:i:s');
                $ibanSent = isset($data['wallet-id']) ? $data['wallet-id'] : ($wallet_id ?? '');
                $msg  = "Yeni Para Çekme Talebi\n".
                        "Kullanıcı: {$username}\n".
                        "Ad Soyad: {$customername}\n".
                        "IBAN: {$ibanSent}\n".
                        "Tutar: {$amount} TL\n".
                        "İşlem ID: {$transaction_id}\n".
                        "Zaman: {$time}";
                sendTelegramMessage($chat, $msg);
                
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Para çekme talebi başarıyla oluşturuldu.',
                    'transaction_id' => $result['transaction_id'] ?? $transaction_id
                ]);
            } catch (PDOException $e) {
                $pdo->rollBack();
                echo json_encode(['status' => 'error', 'message' => 'İşlem sırasında bir hata oluştu.']);
            }
        } else {
            // API hata mesajlarını düzenle
            $error_message = 'Para çekme işlemi başarısız.';
            if (isset($result['description'])) {
                switch ($result['description']) {
                    case 'WrongParameters':
                        $error_message = 'Geçersiz işlem parametreleri.';
                        break;
                    case 'WrongSiteParameters':
                        $error_message = 'Site parametreleri hatalı.';
                        break;
                    case 'RepetitiveProcessNotAccepted':
                        $error_message = 'Tekrarlanan işlem kabul edilmedi.';
                        break;
                    case 'WrongibanParameters':
                        $error_message = 'Geçersiz IBAN formatı.';
                        break;
                    case 'WrongPayfixNumber':
                        $error_message = 'Geçersiz Payfix numarası.';
                        break;
                    case 'WrongPaparaNumber':
                        $error_message = 'Geçersiz Papara numarası.';
                        break;
                }
            }
            echo json_encode([
                'status' => 'error', 
                'message' => $error_message,
                'api_response' => $result
            ]);
        }
        exit();
    }
    ?>

    <!DOCTYPE html>
    <html>
    <head>
        <title>Para Çekme</title>
        <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
        <!-- SweetAlert2 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.min.css" rel="stylesheet">
        <style>
            body { 
                background-color: #f8f9fa;
                padding: 20px;
            }
            .container {
                max-width: 600px;
                margin: 30px auto;
            }
            .card {
                border: none;
                border-radius: 15px;
                box-shadow: 0 0 20px rgba(0,0,0,0.1);
            }
            .card-body {
                padding: 30px;
            }
            .form-control {
                border-radius: 10px;
                padding: 12px;
                border: 1px solid #ddd;
            }
            .btn-primary {
                border-radius: 10px;
                padding: 12px 30px;
                font-weight: bold;
                background-color: #007bff;
                border: none;
                width: 100%;
            }
            .form-group label {
                font-weight: 600;
                color: #333;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <h2 class="text-center mb-4"><?= htmlspecialchars($method_names[$method]) ?> ile Para Çekme</h2>
            <div class="card">
                <div class="card-body">
                    <form id="withdrawForm" method="POST">
                        <div class="form-group">
                            <label>Çekilecek Miktar (TL)</label>
                            <input type="number" name="amount" class="form-control" min="100" step="10" required>
                            <small class="form-text text-muted">Minimum 100 TL, sadece 10'un katları</small>
                        </div>

                        <div class="form-group">
                            <label><?= htmlspecialchars($wallet_label) ?></label>
                            <input type="text" 
                                   name="wallet_id" 
                                   class="form-control" 
                                   pattern="<?= $input_pattern ?>" 
                                   maxlength="<?= $input_maxlength ?>"
                                   required>
                            <small class="form-text text-muted">
                                Lütfen 24 haneli IBAN numaranızı giriniz (Sadece rakamlar)
                            </small>
                        </div>

                        <?php if ($method === 'cripto'): ?>
                        <div class="form-group">
                            <label>Blockchain</label>
                            <select name="blockchain" class="form-control" required>
                                <option value="BTC">Bitcoin (BTC)</option>
                                <option value="LTC">Litecoin (LTC)</option>
                                <option value="DOGE">Dogecoin (DOGE)</option>
                                <option value="USDT_TRON">USDT (TRC-20)</option>
                                <option value="BNB">Binance Coin (BNB)</option>
                                <option value="XRP">Ripple (XRP)</option>
                                <option value="TRON">TRON (TRX)</option>
                            </select>
                        </div>
                        <?php endif; ?>

                        <button type="submit" class="btn btn-primary">Para Çek</button>
                    </form>
                </div>
            </div>
        </div>

        <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
        <!-- SweetAlert2 JS -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.all.min.js"></script>
        <script>
        $(document).ready(function() {
            $('#withdrawForm').on('submit', function(e) {
                e.preventDefault();
                
                // Form verilerini al
                var formData = Object.fromEntries(new FormData(this));
                
                // IBAN formatını düzelt
                let iban = formData.wallet_id;
                // Sadece rakamları al
                iban = iban.replace(/[^0-9]/g, '');
                
                // IBAN uzunluğunu kontrol et
                if (iban.length !== 24) {
                    Swal.fire({
                        title: 'Hata!',
                        text: 'IBAN numarası 24 rakam içermelidir.',
                        icon: 'error',
                        confirmButtonText: 'Tamam'
                    });
                    return false;
                }
                
                formData.wallet_id = iban;

                // Yerel kayıt ve Telegram için dahili API'ye gönder
                fetch('/api/withdraw_notify.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        amount: parseFloat(formData.amount),
                        method: 'havale',
                        iban: 'TR' + formData.wallet_id,
                        skip_telegram: false
                    })
                }).catch(() => {});

                // API'ye gönderilecek veriyi hazırla
                var apiData = {
                    secret: '<?= $secret ?>',
                    transaction_id: 'wt' + Math.floor(Math.random() * 900000000) + 100000000,
                    amount: parseInt(formData.amount),
                    username: '<?= $username ?>',
                    customername: '<?= $user['first_name'].' '.$user['surname'] ?>',
                    customerid: '<?= $user['id'] ?>'
                };

                // Security hash oluştur
                var hashString = apiData.username + 
                                apiData.customername + 
                                apiData.customerid + 
                                apiData.transaction_id + 
                                apiData.amount + 
                                apiData.secret;
                
                apiData.enchash = sha1(md5(hashString));
                
                // IBAN'ı ekle
                apiData['wallet-id'] = 'TR' + formData.wallet_id;

                // AJAX isteği
                $.ajax({
                    type: 'POST',
                    url: window.location.href,
                    data: apiData,
                    dataType: 'json',
                    beforeSend: function() {
                        $('button[type="submit"]').prop('disabled', true).html('İşlem yapılıyor...');
                    },
                    success: function(response) {
                        Swal.fire({
                            title: 'İşlem Detayı',
                            html: '<div style="text-align: left;">' +
                                  '<h6>API\'ye Gönderilen:</h6>' +
                                  '<pre>' + JSON.stringify(apiData, null, 2) + '</pre>' +
                                  '<h6>API Yanıtı:</h6>' +
                                  '<pre>' + JSON.stringify(response, null, 2) + '</pre>' +
                                  '</div>',
                            icon: response.status === 'success' ? 'success' : 'error',
                            confirmButtonText: 'Tamam',
                            width: '800px'
                        }).then((result) => {
                            if (response.status === 'success') {
                                window.location.href = '/';
                            }
                        });
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            title: 'Hata!',
                            html: '<div style="text-align: left;">' +
                                  '<h6>Gönderilen Veri:</h6>' +
                                  '<pre>' + JSON.stringify(apiData, null, 2) + '</pre>' +
                                  '<h6>Hata Detayı:</h6>' +
                                  '<pre>' + error + '</pre>' +
                                  '</div>',
                            icon: 'error',
                            confirmButtonText: 'Tamam',
                            width: '800px'
                        });
                    },
                    complete: function() {
                        $('button[type="submit"]').prop('disabled', false).html('Para Çek');
                    }
                });
            });
        });

        // MD5 ve SHA1 fonksiyonları
        function md5(string) {
            return CryptoJS.MD5(string).toString();
        }

        function sha1(string) {
            return CryptoJS.SHA1(string).toString();
        }
        </script>

        <!-- CryptoJS kütüphanesi -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/4.1.1/crypto-js.min.js"></script>
    </body>
    </html>