<?php
session_start(); // Oturum başlat

// Yardımcılar ve yetki
include 'auth.php';
include 'logger.php';
require_permission('users_manage');
event_log('view', 'Affiliate kullanıcı yönetimi görüntülendi', ['admin' => $_SESSION['admin_user'] ?? 'unknown']);

// Veritabanı bağlantı ayarlarını içe aktar
include 'dblive.php';

try {
    $pdo = new PDO("mysql:host=$user_db_servername;dbname=$user_db_name;charset=utf8", $user_db_username, $user_db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Veritabanına bağlanılamadı: " . $e->getMessage());
}

// Yetki kontrolü üstte yapıldı

// Kullanıcı ekleme işlemi
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $kullanici_adi = $_POST['kullanici_adi'];
    $sifre = password_hash($_POST['sifre'], PASSWORD_BCRYPT); // Şifreyi hashle
    $email = $_POST['email'];
    $commission_rate = isset($_POST['commission_rate']) ? trim($_POST['commission_rate']) : '';
    $commission_rate_val = null;
    if ($commission_rate !== '' && is_numeric($commission_rate)) {
        $cr = (float)$commission_rate;
        if ($cr > 0 && $cr <= 1) { $commission_rate_val = $cr; }
    }
    $referans_kodu = rand(100000, 999999); // Rastgele 6 haneli referans kodu
    $role = 'user'; // Kullanıcı rolü

    // Kullanıcıyı veritabanına ekle (PDO)
    try {
        if ($commission_rate_val === null) {
            $stmt = $pdo->prepare("INSERT INTO kullanici2 (kullanici_adi, sifre, email, referans_kodu, created_at, updated_at, role) VALUES (?, ?, ?, ?, NOW(), NOW(), ?)");
            $stmt->execute([$kullanici_adi, $sifre, $email, $referans_kodu, $role]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO kullanici2 (kullanici_adi, sifre, email, commission_rate, referans_kodu, created_at, updated_at, role) VALUES (?, ?, ?, ?, ?, NOW(), NOW(), ?)");
            $stmt->execute([$kullanici_adi, $sifre, $email, $commission_rate_val, $referans_kodu, $role]);
        }
        $newId = $pdo->lastInsertId();
        audit_log('create', 'user', ['id' => $newId, 'kullanici_adi' => $kullanici_adi, 'email' => $email]);
        echo '<p class="success-message">Kullanıcı başarıyla eklendi.</p>';
    } catch (PDOException $e) {
        event_log('error', 'affiliate user create failed', ['kullanici_adi' => $kullanici_adi, 'error' => $e->getMessage()]);
        echo '<p class="error-message">Kullanıcı eklenirken bir hata oluştu: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
}

// Kullanıcıları listeleme
try {
    $stmtList = $pdo->query("SELECT * FROM kullanici2");
    $result = $stmtList->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $result = [];
    echo '<div class="alert alert-danger" role="alert">Veri alınırken hata: ' . htmlspecialchars($e->getMessage()) . '</div>';
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Yönetimi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            background-color: #000;
            color: #fff;
            margin: 0;
            padding: 10px;
            font-size: 12px;
            line-height: 1.4;
        }
        .container {
            max-width: 980px;
            margin: 0 auto;
            background-color: #0b0b0b;
            padding: 10px;
            border-radius: 7px;
            border: 1px solid rgba(255,255,255,.08);
        }
        h2 {
            text-align: center;
            margin-bottom: 8px;
            color: #e5b645;
            font-size: 15px;
        }
        form { margin-bottom: 20px; }
        label { display: block; margin-bottom: 6px; color: #bdc3c7; font-size: 11px; }
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="number"] {
            width: 100%;
            padding: 5px 7px;
            margin-bottom: 8px;
            background: #111;
            color: #fff;
            border: 1px solid #222;
            border-radius: 8px;
            font-size: 11px;
        }
        input[type="number"] { color: #fff; }
        button {
            width: 100%;
            padding: 5px 7px;
            background: linear-gradient(180deg,#e5b645,#d4a536);
            color: #0b1020;
            border: 1px solid rgba(255,255,255,.08);
            border-radius: 8px;
            cursor: pointer;
            font-size: 11px;
        }
        button:hover { filter: brightness(1.05); }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            background: #0b0b0b;
            color: #fff;
            border: 1px solid rgba(255,255,255,.08);
            border-radius: 8px;
            overflow: hidden;
            font-size: 11px;
        }
        th, td {
            border: 1px solid rgba(255,255,255,.08);
            padding: 5px;
            text-align: left;
        }
        th { background-color: #111; color: #e5e5e5; }
        .status-select { width: 100%; padding: 6px; background: #111; color: #fff; border: 1px solid #222; border-radius: 6px; }
        .success-message { color: #2ecc71; }
        .error-message { color: #e74c3c; }
        .back-button {
            background: linear-gradient(180deg,#e5b645,#d4a536);
            color: #0b1020;
            border: 1px solid rgba(255,255,255,.08);
            padding: 5px 10px;
            border-radius: 8px;
            cursor: pointer;
            display: inline-block;
            margin: 10px 0;
            text-align: center;
            font-size: 11px;
        }
        .back-button:hover { filter: brightness(1.05); }
        #affToolbar .form-control { background: #111; color: #fff; border: 1px solid #222; }
        #affToolbar .btn { color: #fff; border-color: #444; }
        #affToolbar .btn-outline-secondary { color: #e5e5e5; border-color: #444; }
        .dropdown-menu { background: #111; color: #fff; border: 1px solid #222; }
        .dropdown-menu .form-check-label { color: #e5e5e5; }
        .input-group .form-control { background: #111; color: #fff; border: 1px solid #222; }
        .btn-outline-success { color: #e5b645; border-color: #d4a536; }
        .btn-outline-primary { color: #e5b645; border-color: #d4a536; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>
            <div class="col-md-10 p-4">

<div class="container">
    <h2>Kullanıcı Yönetimi</h2>
    <div class="d-flex justify-content-center mb-3">
        <button class="btn btn-outline-primary" type="button" data-bs-toggle="modal" data-bs-target="#affInfoModal">Bilgi</button>
    </div>

    <form method="POST" action="">
        <label for="kullanici_adi">Kullanıcı Adı:</label>
        <input type="text" id="kullanici_adi" name="kullanici_adi" required>

        <label for="sifre">Şifre:</label>
        <input type="password" id="sifre" name="sifre" required>

        <label for="email">E-posta:</label>
        <input type="email" id="email" name="email" required>

        <label for="commission_rate">Komisyon Oranı (0–1, örn. 0.10=%10):</label>
        <input type="number" id="commission_rate" name="commission_rate" step="0.01" min="0" max="1" placeholder="0.10">

        <button type="submit">Kullanıcı Oluştur</button>
    </form>

    <h2>Kullanıcı Listesi</h2>
    <!-- Araç Çubuğu: Hızlı Arama, Sütun Görünürlüğü, Görünüm Kaydet/Yükle, CSV Dışa Aktar -->
    <div class="d-flex flex-wrap align-items-center gap-2 mb-3" id="affToolbar">
        <input type="text" class="form-control" id="quickSearchAff" placeholder="Hızlı arama..." style="max-width: 240px;">
        <div class="dropdown">
            <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="columnToggleAff" data-bs-toggle="dropdown" aria-expanded="false">
                Sütun Görünürlüğü
            </button>
            <ul class="dropdown-menu p-2" aria-labelledby="columnToggleAff" id="columnListAff" style="min-width: 220px;"></ul>
        </div>
        <button class="btn btn-outline-primary" id="saveViewAff">Görünümü Kaydet</button>
        <button class="btn btn-outline-primary" id="loadViewAff">Görünümü Yükle</button>
        <button class="btn btn-outline-success" id="exportCsvAff">CSV Dışa Aktar</button>
    </div>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Kullanıcı Adı</th>
                <th>Referans Kodu</th>
                <th>Email</th>
                <th>Komisyon Oranı</th>
                <th>Şifre Değiştir</th>
                <th>Durum</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($result)): ?>
                <?php foreach ($result as $row): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['id']); ?></td>
                        <td><?php echo htmlspecialchars($row['kullanici_adi']); ?></td>
                        <td><?php echo htmlspecialchars($row['referans_kodu']); ?></td>
                        <td><?php echo htmlspecialchars($row['email']); ?></td>
                        <td>
                            <div class="input-group input-group-sm">
                                <input type="number" class="form-control" value="<?php echo htmlspecialchars($row['commission_rate'] ?? '0.10'); ?>" step="0.01" min="0" max="1" id="cr_<?php echo $row['id']; ?>">
                                <button class="btn btn-outline-secondary" onclick="updateCommission(<?php echo $row['id']; ?>)">Kaydet</button>
                            </div>
                        </td>
                        <td>
                            <div class="input-group input-group-sm">
                                <input type="password" class="form-control" placeholder="Yeni şifre" id="pw_<?php echo $row['id']; ?>">
                                <button class="btn btn-outline-secondary" onclick="updatePassword(<?php echo $row['id']; ?>)">Güncelle</button>
                            </div>
                            <small class="text-muted">En az 6 karakter</small>
                        </td>
                        <td>
                            <select class="status-select" name="durum" onchange="updateStatus(<?php echo $row['id']; ?>, this.value)">
                                <option value="Beklemede" <?php if ($row['durum'] == 'Beklemede') echo 'selected'; ?>>Beklemede</option>
                                <option value="Onaylandı" <?php if ($row['durum'] == 'Onaylandı') echo 'selected'; ?>>Onaylandı</option>
                                <option value="Reddedildi" <?php if ($row['durum'] == 'Reddedildi') echo 'selected'; ?>>Reddedildi</option>
                            </select>
                        </td>
                        <td>
                            <button onclick="deleteUser(<?php echo $row['id']; ?>)">Sil</button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">Kayıt bulunamadı.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <button class="back-button" onclick="window.history.back();">Önceki Sayfaya Dön</button>
</div>

<script>
    (function() {
        const table = document.querySelector('table');
        if (!table) return;
        const pageKey = 'aff';
        const quickSearch = document.getElementById('quickSearchAff');
        const columnList = document.getElementById('columnListAff');
        const saveBtn = document.getElementById('saveViewAff');
        const loadBtn = document.getElementById('loadViewAff');
        const exportBtn = document.getElementById('exportCsvAff');

        const headers = Array.from(table.querySelectorAll('thead th'));
        const rows = Array.from(table.querySelectorAll('tbody tr'));

        // Sütun listesi
        headers.forEach((th, idx) => {
            const li = document.createElement('li');
            li.className = 'dropdown-item';
            const id = `aff-col-${idx}`;
            li.innerHTML = `<div class=\"form-check\"><input class=\"form-check-input\" type=\"checkbox\" id=\"${id}\" data-col-index=\"${idx}\" checked><label class=\"form-check-label\" for=\"${id}\">${th.textContent.trim()}</label></div>`;
            columnList.appendChild(li);
        });

        function setColumnVisible(colIndex, visible) {
            headers[colIndex].style.display = visible ? '' : 'none';
            rows.forEach(tr => {
                const cells = tr.children;
                if (cells[colIndex]) cells[colIndex].style.display = visible ? '' : 'none';
            });
        }

        columnList.addEventListener('change', (e) => {
            const input = e.target.closest('input[data-col-index]');
            if (!input) return;
            const idx = parseInt(input.dataset.colIndex, 10);
            setColumnVisible(idx, input.checked);
        });

        // Hızlı arama
        quickSearch.addEventListener('input', () => {
            const q = quickSearch.value.toLowerCase();
            rows.forEach(tr => {
                const text = tr.textContent.toLowerCase();
                tr.style.display = text.includes(q) ? '' : 'none';
            });
        });

        // Görünüm kaydet/yükle
        function getViewState() {
            const columns = headers.map((th, idx) => ({ name: th.textContent.trim(), visible: th.style.display !== 'none', idx }));
            return { columns };
        }
        function applyViewState(state) {
            if (!state || !state.columns) return;
            state.columns.forEach(col => setColumnVisible(col.idx, col.visible));
            columnList.querySelectorAll('input[data-col-index]').forEach(input => {
                const col = state.columns.find(c => c.idx === parseInt(input.dataset.colIndex, 10));
                if (col) input.checked = col.visible;
            });
        }
        saveBtn.addEventListener('click', () => {
            localStorage.setItem('tableView_' + pageKey, JSON.stringify(getViewState()));
            saveBtn.textContent = 'Kaydedildi';
            setTimeout(() => saveBtn.textContent = 'Görünümü Kaydet', 1200);
        });
        loadBtn.addEventListener('click', () => {
            const raw = localStorage.getItem('tableView_' + pageKey);
            if (!raw) return;
            try { applyViewState(JSON.parse(raw)); } catch (e) {}
        });

        // CSV dışa aktar
        exportBtn.addEventListener('click', () => {
            const visibleCols = headers.map((h, i) => ({ i, txt: h.textContent.trim() })).filter(c => headers[c.i].style.display !== 'none');
            const lines = [];
            lines.push(visibleCols.map(c => '"' + c.txt.replace(/"/g, '""') + '"').join(','));
            rows.forEach(tr => {
                if (tr.style.display === 'none') return; // Filtrelenenleri atla
                const cells = Array.from(tr.children);
                const vals = visibleCols.map(c => cells[c.i] ? cells[c.i].innerText.trim() : '');
                lines.push(vals.map(v => '"' + v.replace(/"/g, '""') + '"').join(','));
            });
            const blob = new Blob([lines.join('\n')], { type: 'text/csv;charset=utf-8;' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'affiliate_kullanicilar.csv';
            a.click();
            URL.revokeObjectURL(url);
        });
    })();
    function updateStatus(userId, status) {
        // AJAX ile durumu güncelle
        const xhr = new XMLHttpRequest();
        xhr.open("POST", "update_status.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4 && xhr.status === 200) {
                alert("Durum güncellendi!");
            }
        };
        xhr.send("id=" + userId + "&durum=" + status);
    }

    function deleteUser(userId) {
        if (confirm("Bu kullanıcıyı silmek istediğinize emin misiniz?")) {
            // AJAX ile kullanıcıyı sil
            const xhr = new XMLHttpRequest();
            xhr.open("POST", "delete_user.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    location.reload(); // Sayfayı yenile
                }
            };
            xhr.send("id=" + userId);
        }
    }

    function updateCommission(userId) {
        const input = document.getElementById('cr_' + userId);
        if (!input) return;
        const val = input.value.trim();
        if (val === '' || isNaN(val)) { alert('Geçerli bir oran giriniz (0-1).'); return; }
        const num = parseFloat(val);
        if (num < 0 || num > 1) { alert('Oran 0 ile 1 arasında olmalıdır.'); return; }
        const xhr = new XMLHttpRequest();
        xhr.open("POST", "update_commission.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    alert('Komisyon oranı güncellendi');
                } else {
                    alert('Güncelleme başarısız: ' + xhr.responseText);
                }
            }
        };
        xhr.send("id=" + encodeURIComponent(userId) + "&commission_rate=" + encodeURIComponent(num));
    }

    function updatePassword(userId) {
        const input = document.getElementById('pw_' + userId);
        if (!input) return;
        const val = input.value;
        if (!val || val.length < 6) { alert('Şifre en az 6 karakter olmalıdır.'); return; }
        const xhr = new XMLHttpRequest();
        xhr.open("POST", "update_password.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    alert('Şifre güncellendi'); input.value = '';
                } else {
                    alert('Şifre güncelleme başarısız: ' + xhr.responseText);
                }
            }
        };
        xhr.send("id=" + encodeURIComponent(userId) + "&password=" + encodeURIComponent(val));
    }
</script>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <div class="modal fade" id="affInfoModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content" style="background:#0b0b0b;color:#fff;border:1px solid rgba(255,255,255,.08)">
          <div class="modal-header" style="border-bottom:1px solid rgba(255,255,255,.08)">
            <h5 class="modal-title" style="color:#e5b645">Affiliate Bilgi</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <p>Komisyon oranı 0-1 aralığında bir katsayıdır. Örneğin <strong>0.10</strong> değeri %10 komisyonu ifade eder.</p>
            <p>Şifre güncellemesi admin tarafından yapılır ve bcrypt ile güvenle saklanır.</p>
            <p>Referans kodu her kullanıcı için otomatik atanır ve davet linkleriyle kullanılır.</p>
          </div>
          <div class="modal-footer" style="border-top:1px solid rgba(255,255,255,.08)">
            <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Kapat</button>
          </div>
        </div>
      </div>
    </div>
</body>
</html>


// Veritabanı bağlantı ayarlarını içe aktar
include 'dblive.php';

