<?php
// Merkezi rol/yetki yardımcıları
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Rol -> yetkiler matrisi
$ROLES_PERMISSIONS = [
    'superadmin' => [
        'dashboard_view','users_manage','games_manage','banks_manage','bonus_manage',
        'deposit_review','withdraw_review','reports_view','content_manage','analytics_view',
        // yeni, ince taneli izinler
        'reports_export','finance_bulk','user_delete','users_view_sensitive','users_freeze',
        // yeni özellik yetkileri
        'tournaments_manage','events_manage','bonuses_manage','mini_games_manage','cashback_manage','loyalty_manage'
    ],
    'finance' => [
        'deposit_review','withdraw_review','reports_view','analytics_view','banks_manage',
        'finance_bulk','cashback_manage'
    ],
    'support' => [
        'users_manage','bonus_manage','reports_view','users_view_sensitive','users_freeze',
        'bonuses_manage','tournaments_manage','events_manage','loyalty_manage'
    ],
    'content' => ['content_manage','games_manage','bonus_manage','mini_games_manage','events_manage','loyalty_manage'],
    'analyst' => ['reports_view','analytics_view','dashboard_view','reports_export']
];

function current_role() {
    return isset($_SESSION['admin_role']) ? $_SESSION['admin_role'] : 'superadmin';
}

function has_permission($perm) {
    global $ROLES_PERMISSIONS;
    $role = current_role();
    return isset($ROLES_PERMISSIONS[$role]) && in_array($perm, $ROLES_PERMISSIONS[$role], true);
}

function require_permission($perm) {
    if (!isset($_SESSION['admin_logged_in'])) {
        header('Location: index.php');
        exit;
    }
    if (!has_permission($perm)) {
        http_response_code(403);
        echo '<div style="padding:20px;color:#fff;background:#8b0000;">Bu sayfaya erişim yetkiniz yok.</div>';
        exit;
    }
}
?>