<?php
include 'config.php';

$response = ['success' => false, 'message' => 'Geçersiz istek'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userId = $_POST['userIdPassword'];
    $currentPassword = $_POST['currentPassword'];
    $newPassword = $_POST['newPassword'];

    // Kullanıcıyı veritabanından al
    $stmt = $pdo->prepare("SELECT * FROM kullanicilar WHERE id = :userId LIMIT 1");
    $stmt->bindParam(':userId', $userId);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($currentPassword, $user['password'])) {
        // Yeni şifreyi güvenli bir şekilde kaydet
        $newPasswordHash = password_hash($newPassword, PASSWORD_DEFAULT);

        // Şifreyi güncelle
        $updateStmt = $pdo->prepare("UPDATE kullanicilar SET password = :newPassword WHERE id = :userId");
        $updateStmt->bindParam(':newPassword', $newPasswordHash);
        $updateStmt->bindParam(':userId', $userId);
        if ($updateStmt->execute()) {
            $response = ['success' => true, 'message' => 'Şifre başarıyla değiştirildi'];
        } else {
            $response['message'] = 'Şifre güncellenirken bir hata oluştu';
        }
    } else {
        $response['message'] = 'Mevcut şifre yanlış';
    }
}

echo json_encode($response);
?>
