<?php
session_start();

// Veritabanı bağlantısı
$host = 'localhost';  // Veritabanı sunucu adresi
$dbname = 'blacrhdy_bet1';  // Veritabanı adı
$username = 'blacrhdy_bet1';  // Veritabanı kullanıcı adı
$password = 'blacrhdy_bet1';  // Veritabanı şifresi
// PDO ile veritabanına bağlantı
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    // PDO hata modunu exception olarak ayarla
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Veritabanı bağlantısı kurulamadı: " . $e->getMessage());
}

// Kullanıcı girişi kontrolü
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit;
}

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Formdan gelen verileri al
    $kullanici_adi = trim($_POST['kullanici_adi']);
    $sifre = trim($_POST['sifre']);
    $referans_kodu = trim($_POST['referans_kodu']);
    $email = trim($_POST['email']);
    $role = $_POST['role'];

    // Şifreyi güvenli bir şekilde hash'le
    $hashedPassword = password_hash($sifre, PASSWORD_BCRYPT);

    // Referans kodu boşsa, rastgele oluştur
    if (empty($referans_kodu)) {
        $referans_kodu = generateRandomCode();
    }

    // Veritabanına yeni kullanıcıyı ekle
    try {
        $stmt = $pdo->prepare("INSERT INTO kullanicilar (kullanici_adi, sifre, referans_kodu, email, role, aylik_bakiye) 
                               VALUES (:kullanici_adi, :sifre, :referans_kodu, :email, :role, 0)");
        $stmt->execute([
            'kullanici_adi' => $kullanici_adi, 
            'sifre' => $hashedPassword, 
            'referans_kodu' => $referans_kodu, 
            'email' => $email, 
            'role' => $role
        ]);

        // Başarı mesajı
        echo "<p>Kullanıcı başarıyla oluşturuldu. Kullanıcı adı: $kullanici_adi, Referans Kodu: $referans_kodu</p>";
    } catch (PDOException $e) {
        echo "<p>Hata: " . $e->getMessage() . "</p>";
    }
}

// Rastgele referans kodu oluşturma fonksiyonu
function generateRandomCode($length = 8) {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomCode = '';
    for ($i = 0; $i < $length; $i++) {
        $randomCode .= $characters[mt_rand(0, strlen($characters) - 1)];
    }
    return $randomCode;
}
?>