<?php
session_start();
include 'config.php';

// Admin login control
if (!isset($_SESSION['admin_logged_in'])) {
    echo json_encode(['success' => false, 'message' => 'Yetkisiz erişim.']);
    exit;
}

// Get the game ID from the request
$data = json_decode(file_get_contents('php://input'), true);
$gameId = isset($data['id']) ? (int)$data['id'] : 0;

// Check if the ID is valid
if ($gameId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz oyun ID.']);
    exit;
}

// Delete game query
$query = "DELETE FROM games WHERE id = :game_id";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':game_id', $gameId, PDO::PARAM_INT);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Silme işlemi başarısız oldu.']);
}
?>
