<?php
session_start();
header('Content-Type: text/plain; charset=utf-8');
include 'auth.php';
include 'logger.php';
require_permission('users_manage');

// Yalnızca admin girişliyken işlem yapılmasına izin ver
if (!isset($_SESSION['admin_logged_in'])) {
    http_response_code(401);
    echo 'Unauthorized';
    exit;
}

// DB kimlik bilgilerini al
include 'dblive.php';

try {
    $pdo = new PDO("mysql:host=$user_db_servername;dbname=$user_db_name;charset=utf8", $user_db_username, $user_db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo 'DB connect error: ' . htmlspecialchars($e->getMessage());
    exit;
}

// Girdi doğrulama
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

if ($id <= 0) {
    http_response_code(200);
    echo 'No change';
    exit;
}

try {
    $stmt = $pdo->prepare('DELETE FROM kullanici2 WHERE id = :id');
    $stmt->execute([':id' => $id]);

    audit_log('delete', 'user', ['id' => $id]);

    // Her durumda 200 döndür, istemci tarafı mesajı yönetiyor
    http_response_code(200);
    echo 'OK';
} catch (PDOException $e) {
    http_response_code(500);
    echo 'DB error: ' . htmlspecialchars($e->getMessage());
    event_log('error', 'delete_user failed', ['id' => $id, 'error' => $e->getMessage()]);
}