<?php
include 'config.php';  // Veritabanı bağlantısını al

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Form verilerini al
    $userId = $_POST['userId'];
    $firstName = $_POST['firstName'];
    $surname = $_POST['surname'];
    $username = $_POST['username'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $anaBakiye = $_POST['anaBakiye'];
    $tcKimlikNo = $_POST['tcKimlikNo'];

    // Veritabanında kullanıcıyı güncelle
    $stmt = $pdo->prepare("
        UPDATE kullanicilar 
        SET first_name = :first_name, surname = :surname, username = :username, email = :email, 
            phone = :phone, ana_bakiye = :ana_bakiye, tc_kimlik_no = :tc_kimlik_no 
        WHERE id = :id
    ");
    $stmt->bindParam(':first_name', $firstName);
    $stmt->bindParam(':surname', $surname);
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':phone', $phone);
    $stmt->bindParam(':ana_bakiye', $anaBakiye);
    $stmt->bindParam(':tc_kimlik_no', $tcKimlikNo);
    $stmt->bindParam(':id', $userId);

    try {
        if ($stmt->execute()) {
            // Eğer başarılıysa JSON formatında başarılı sonucu döndürüyoruz
            echo json_encode(['success' => true]);
        } else {
            // Eğer işlem başarısızsa hata mesajını alıyoruz
            $errorInfo = $stmt->errorInfo();
            echo json_encode(['success' => false, 'error' => $errorInfo[2]]);
        }
    } catch (PDOException $e) {
        // Veritabanı hata mesajı
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
}
?>
