<?php
include 'config.php'; // Veritabanı bağlantısını ekleyin


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Kullanıcıdan gelen verileri al
    $url = trim($_POST['url']);
    $alt_text = trim($_POST['alt_text']);

    // Basit URL ve alt metin validasyonu
    if (empty($url) || empty($alt_text)) {
        header("Location: slider.php?error=empty_fields");
        exit();
    }

    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        header("Location: slider.php?error=invalid_url");
        exit();
    }

    // Veritabanına ekleme işlemi
    try {
        $stmt = $pdo->prepare("INSERT INTO gorseller (url, alt_text) VALUES (:url, :alt_text)");
        $stmt->bindParam(':url', $url);
        $stmt->bindParam(':alt_text', $alt_text);
        
        if ($stmt->execute()) {
            // Başarılı ekleme işlemi sonrası yönlendirme
            header("Location: slider.php?success=1");
            exit();
        } else {
            // Hata durumunda yönlendirme
            header("Location: slider.php?error=1");
            exit();
        }
    } catch (PDOException $e) {
        // Hata durumunda yönlendirme
        // Hata detaylarını loglamak isteyebilirsiniz
        error_log("Database Error: " . $e->getMessage());
        header("Location: slider.php?error=1");
        exit();
    }
}
?>
