<?php
session_start();
include 'config.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit;
}

// betsi çekiyoruz
$stmt = $pdo->query("SELECT * FROM bets ORDER BY username, bet_description");
$bets = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Kullanıcı betsini gruplamak
$groupedBets = [];
foreach ($bets as $bahis) {
    $groupedBets[$bahis['username']][$bahis['bet_description']][] = $bahis;
}

// Maç durumu veya grup işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['match_id']) && isset($_POST['match_action'])) {
        // Tek maç için durum güncellemesi
        $matchId = $_POST['match_id'];
        $action = $_POST['match_action'];

        $stmt = $pdo->prepare("UPDATE bets SET status = :status WHERE id = :id");
        $stmt->execute(['status' => $action, 'id' => $matchId]);
    } elseif (isset($_POST['username']) && isset($_POST['bet_description']) && isset($_POST['group_action'])) {
        // Grup seviyesi işlem (Kazandı -> bakiye ekleme)
        $username = $_POST['username'];
        $betType = $_POST['bet_description'];
        $action = $_POST['group_action'];

        if ($action === 'Kazandı') {
            // Grup kontrolü: Tüm maçlar "Kazandı" mı?
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM bets WHERE username = :username AND bet_description = :bet_description AND status != 'Kazandı'");
            $stmt->execute(['username' => $username, 'bet_description' => $betType]);
            $pendingCount = $stmt->fetchColumn();

            if ($pendingCount == 0) {
                // Potansiyel kazançları toplama
                $stmt = $pdo->prepare("SELECT SUM(potential_winnings) AS total_winnings FROM bets WHERE username = :username AND bet_description = :bet_description");
                $stmt->execute(['username' => $username, 'bet_description' => $betType]);
                $totalWinnings = $stmt->fetchColumn();

                // Kullanıcı bakiyesine ekleme
                $stmt = $pdo->prepare("UPDATE kullanicilar SET ana_bakiye = ana_bakiye + :total_winnings WHERE username = :username");
                $stmt->execute(['total_winnings' => $totalWinnings, 'username' => $username]);
            }
        }
    }

    header("Location: guncellendi.php"); // Sayfayı yenile
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Paneli</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>
            <div class="col-md-10 p-4">
    <div class="container mt-5">
        <h2 class="mb-4 text-warning">Admin Paneli - Bahis Yönetimi</h2>

        <?php foreach ($groupedBets as $username => $betsByType): ?>
            <div class="user-container mb-4">
                <h4 class="text-primary">Kullanıcı: <?= htmlspecialchars($username) ?></h4>

                <?php foreach ($betsByType as $betType => $bets): ?>
                    <div class="bet-container mb-3 p-3">
                        <h5 class="text-success"><?= htmlspecialchars($betType) ?></h5>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Etkinlik</th>
                                    <th>Oran</th>
                                    <th>Miktar</th>
                                    <th>Olası Kazanç</th>
                                    <th>Durum</th>
                                    <th>İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($bets as $bet): ?>
                                <tr>
                                    <td><?= htmlspecialchars($bet['id']) ?></td>
                                    <td><?= htmlspecialchars($bet['event_name']) ?></td>
                                    <td><?= htmlspecialchars($bet['odd_value']) ?></td>
                                    <td><?= htmlspecialchars($bet['stake_amount']) ?></td>
                                    <td><?= htmlspecialchars($bet['potential_winnings']) ?></td>
                                    <td><?= htmlspecialchars($bet['status']) ?></td>
                                    <td>
                                        <form method="post" class="d-inline">
                                            <input type="hidden" name="match_id" value="<?= htmlspecialchars($bet['id']) ?>">
                                            <button type="submit" name="match_action" value="Kazandı" class="btn btn-success btn-sm">Kazandı</button>
                                            <button type="submit" name="match_action" value="Kaybetti" class="btn btn-danger btn-sm">Kaybetti</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        <form method="post" class="d-flex justify-content-end mt-2">
                            <input type="hidden" name="username" value="<?= htmlspecialchars($username) ?>">
                            <input type="hidden" name="bet_description" value="<?= htmlspecialchars($betType) ?>">
                            <button type="submit" name="group_action" value="Kazandı" class="btn btn-primary me-2">Grubu Kazandı</button>
                            <button type="submit" name="group_action" value="Kaybetti" class="btn btn-secondary">Grubu Kaybetti</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endforeach; ?>
    </div>
            </div>
        </div>
    </div>
</body>
</html>
