<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);

session_start();
include 'config.php';
include 'logger.php';
include 'auth.php';

// Zaten giriş yapılmışsa direkt dashboard'a yönlendir
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: dashboard.php");
    exit;
}

$error_message = ''; // Hata mesajı için değişken

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM admin WHERE username = ?");
    $stmt->execute([$username]);
    $admin = $stmt->fetch();

    if ($admin && password_verify($password, $admin['password'])) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_user'] = $admin['username'] ?? $username;
        $_SESSION['admin_role'] = $admin['role'] ?? 'superadmin';
        login_log($username, 'success', 'Admin login successful');
        header("Location: dashboard.php");
        exit;
    } else {
        $error_message = 'Bu erişime yetkiniz bulunmamaktadır.'; // Hata mesajı
        login_log($username, 'failure', 'Invalid credentials');
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Girişi</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet"> <!-- Özel yazı tipi -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        html, body {
            height: 100%;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #000000; /* Arkaplan siyah */
            font-family: 'Poppins', sans-serif; /* Özel yazı tipi */
        }

        .login-box {
            background: #222222; /* Koyu gri arka plan */
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.5);
            width: 100%;
            max-width: 350px;
        }

        .login-box h3 {
            color: #FFD700; /* Sarı renk başlık */
            font-size: 1.8rem; /* Daha büyük başlık boyutu */
            font-weight: 600;
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .form-label {
            color: #ffffff;
            font-size: 1.1rem;
        }

        .form-control {
            background: #333333;
            border: 1px solid #444444;
            color: #ffffff;
            font-size: 1rem;
            padding: 0.8rem;
            border-radius: 5px;
            width: 100%;
        }

        .form-control:focus {
            outline: none;
            border-color: #FFD700;
            box-shadow: 0 0 8px #FFD700;
        }

        .form-control[placeholder] {
            color: #bbb;
        }

        button {
            background: #FFD700; /* Sarı buton */
            color: #000000;
            border: none;
            padding: 0.8rem;
            font-size: 1.1rem;
            font-weight: bold;
            border-radius: 5px;
            transition: background-color 0.3s ease;
            width: 100%;
            margin-top: 1rem;
        }

        button:hover {
            background: #FFC107;
        }

        button:focus {
            outline: none;
            box-shadow: 0 0 10px #FFD700;
        }
    </style>
</head>
<body>

<div class="login-box">
    <h3>Admin Girişi</h3>
    <form method="post">
        <div class="mb-3">
            <input type="text" id="username" name="username" class="form-control" placeholder="Kullanıcı Adı" required>
        </div>
        <div class="mb-3">
            <input type="password" id="password" name="password" class="form-control" placeholder="Şifre" required>
        </div>
        <button type="submit">Giriş Yap</button>
    </form>
</div>

<script>
    // PHP ile belirlenen hata mesajını kontrol et
    <?php if (!empty($error_message)) { ?>
        Swal.fire({
            icon: 'error',
            title: 'Erişim Reddedildi',
            text: '<?php echo $error_message; ?>',
            showConfirmButton: true,
            timer: 3000
        });
    <?php } ?>
</script>

</body>
</html>

