<?php
session_start();
require_once __DIR__ . '/auth.php';
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$logPath = realpath(__DIR__ . '/../inc/error.log');
if (!$logPath) {
    $logPath = __DIR__ . '/../inc/error.log';
}

// İndir
if (isset($_GET['download']) && file_exists($logPath)) {
    header('Content-Type: text/plain');
    header('Content-Disposition: attachment; filename="error.log"');
    readfile($logPath);
    exit;
}

// Temizle
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'clear') {
    if (is_writable(dirname($logPath))) {
        file_put_contents($logPath, '');
        $message = 'Log dosyası temizlendi.';
    } else {
        $message = 'Log dosyası yazılabilir değil.';
    }
}

$lines = [];
if (file_exists($logPath)) {
    $content = file_get_contents($logPath);
    $lines = explode("\n", $content);
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log Görüntüleyici</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
    <style>
        .log-container { max-height: 500px; overflow: auto; background: #111; color: #eee; padding: 12px; border-radius: 6px; }
        .log-line { white-space: pre; font-family: ui-monospace, Menlo, Consolas, monospace; border-bottom: 1px dashed #333; padding: 4px 0; }
        .toolbar { display:flex; gap:8px; align-items:center; margin-bottom: 12px; }
        .toolbar input[type="text"] { flex:1; }
    </style>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/sidebar.php'; ?>

            <div class="col-md-10 p-4">
                <h1>Log Görüntüleyici</h1>
                <p class="text-muted">Uygulama hatalarını ve uyarıları görüntüleyin, indirin veya temizleyin.</p>

                <?php if ($message): ?>
                <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
                <?php endif; ?>

                <div class="toolbar">
                    <input type="text" id="quickSearch" class="form-control" placeholder="Log içinde ara...">
                    <a href="logs_viewer.php?download=1" class="btn btn-secondary">İndir</a>
                    <form method="POST" style="display:inline;" onsubmit="return confirm('Log dosyası temizlenecek. Emin misiniz?');">
                        <input type="hidden" name="action" value="clear">
                        <button type="submit" class="btn btn-danger">Temizle</button>
                    </form>
                </div>

                <div class="log-container" id="logContainer">
                    <?php if (!file_exists($logPath)): ?>
                        <div class="alert alert-warning">Log dosyası bulunamadı: <?= htmlspecialchars($logPath) ?></div>
                    <?php else: ?>
                        <?php foreach ($lines as $i => $line): ?>
                            <?php if ($line === '') continue; ?>
                            <div class="log-line" data-text="<?= htmlspecialchars(strtolower($line)) ?>"><?= htmlspecialchars($line) ?></div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Basit quick search filtresi
        const $search = $('#quickSearch');
        const $lines = $('.log-line');
        $search.on('input', function() {
            const q = $(this).val().toLowerCase();
            if (!q) { $lines.show(); return; }
            $lines.each(function() {
                const t = $(this).data('text');
                $(this).toggle(t.indexOf(q) !== -1);
            });
        });
    </script>
</body>
</html>