<?php
require_once __DIR__ . '/config.php';

header('Content-Type: text/plain; charset=utf-8');

try {
    // 1) Tablo var mı kontrol et
    $tblStmt = $pdo->query("SHOW TABLES LIKE 'bankalar'");
    $tableExists = (bool) $tblStmt->fetchColumn();

    if (!$tableExists) {
        echo "Uyarı: 'bankalar' tablosu bulunamadı. Oluşturuluyor...\n";
        $pdo->exec("CREATE TABLE IF NOT EXISTS bankalar (
            id INT AUTO_INCREMENT PRIMARY KEY,
            banka_adi VARCHAR(255) NOT NULL,
            adsoyad VARCHAR(255) NOT NULL,
            iban VARCHAR(64) NOT NULL,
            hesap_no VARCHAR(50) NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
        echo "'bankalar' tablosu oluşturuldu.\n";
        echo "Migration tamamlandı.\n";
        exit;
    }

    // 2) 'hesap_no' kolonu var mı kontrol et
    $colStmt = $pdo->query("SHOW COLUMNS FROM bankalar LIKE 'hesap_no'");
    $colExists = (bool) $colStmt->fetchColumn();

    if ($colExists) {
        echo "'hesap_no' kolonu zaten mevcut. Yapılacak bir işlem yok.\n";
        exit;
    }

    // 3) Kolonu ekle
    $pdo->exec("ALTER TABLE bankalar ADD COLUMN hesap_no VARCHAR(50) NULL AFTER iban");
    echo "'hesap_no' kolonu başarıyla eklendi.\n";
    echo "Migration tamamlandı.\n";
} catch (Throwable $e) {
    http_response_code(500);
    echo "Hata: " . $e->getMessage() . "\n";
}