<?php
// Basit affiliate şeması migration scripti
// - kullanicilar tablosuna: referans_kodu, referred_by, referred_at, invite_count sütunları eklenir
// - benzersiz referans kodu index'i eklenir
// - mevcut kullanıcılar için referans_kodu doldurulur

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Veritabanı bağlantısı
$host = 'localhost';
$db = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_error) {
    die('DB bağlantı hatası: ' . $mysqli->connect_error);
}

function columnExists(mysqli $db, string $table, string $column): bool {
    $stmt = $db->prepare('SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?');
    $schema = $db->real_escape_string($db->query('SELECT DATABASE()')->fetch_row()[0]);
    $stmt->bind_param('sss', $schema, $table, $column);
    $stmt->execute();
    $stmt->bind_result($cnt);
    $stmt->fetch();
    $stmt->close();
    return (int)$cnt > 0;
}

function indexExists(mysqli $db, string $table, string $indexName): bool {
    $stmt = $db->prepare('SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND INDEX_NAME = ?');
    $schema = $db->real_escape_string($db->query('SELECT DATABASE()')->fetch_row()[0]);
    $stmt->bind_param('sss', $schema, $table, $indexName);
    $stmt->execute();
    $stmt->bind_result($cnt);
    $stmt->fetch();
    $stmt->close();
    return (int)$cnt > 0;
}

function safeAlter(mysqli $db, string $sql): void {
    if (!$db->query($sql)) {
        echo '\nALTER hatası: ' . $db->error . '\n';
        exit(1);
    }
}

// Sütunları ekle
if (!columnExists($mysqli, 'kullanicilar', 'referans_kodu')) {
    safeAlter($mysqli, "ALTER TABLE kullanicilar ADD COLUMN referans_kodu VARCHAR(12) NULL");
}
if (!columnExists($mysqli, 'kullanicilar', 'referred_by')) {
    safeAlter($mysqli, "ALTER TABLE kullanicilar ADD COLUMN referred_by VARCHAR(12) NULL");
}
if (!columnExists($mysqli, 'kullanicilar', 'referred_at')) {
    safeAlter($mysqli, "ALTER TABLE kullanicilar ADD COLUMN referred_at DATETIME NULL");
}
if (!columnExists($mysqli, 'kullanicilar', 'invite_count')) {
    safeAlter($mysqli, "ALTER TABLE kullanicilar ADD COLUMN invite_count INT NOT NULL DEFAULT 0");
}

// Indexler
if (!indexExists($mysqli, 'kullanicilar', 'uniq_referans_kodu')) {
    safeAlter($mysqli, "ALTER TABLE kullanicilar ADD UNIQUE KEY uniq_referans_kodu (referans_kodu)");
}
if (!indexExists($mysqli, 'kullanicilar', 'idx_referred_by')) {
    safeAlter($mysqli, "ALTER TABLE kullanicilar ADD INDEX idx_referred_by (referred_by)");
}

// Kod üretim yardımcıları
function generateCode(int $len = 8): string {
    $chars = '23456789ABCDEFGHJKLMNPQRSTUVWXYZ'; // kolay okunur
    $out = '';
    for ($i = 0; $i < $len; $i++) {
        $out .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $out;
}

function codeExists(mysqli $db, string $code): bool {
    $stmt = $db->prepare('SELECT COUNT(*) FROM kullanicilar WHERE referans_kodu = ?');
    $stmt->bind_param('s', $code);
    $stmt->execute();
    $stmt->bind_result($cnt);
    $stmt->fetch();
    $stmt->close();
    return (int)$cnt > 0;
}

// Mevcut kullanıcılar için referans_kodu doldur
$res = $mysqli->query("SELECT id FROM kullanicilar WHERE referans_kodu IS NULL OR referans_kodu = ''");
if ($res) {
    $updated = 0;
    while ($row = $res->fetch_assoc()) {
        $id = (int)$row['id'];
        // benzersiz kod üret
        $attempts = 0;
        do {
            $code = generateCode(8);
            $attempts++;
        } while (codeExists($mysqli, $code) && $attempts < 20);
        if ($attempts >= 20) {
            echo "\nKod üretilemedi (id={$id}).\n";
            continue;
        }
        $stmt = $mysqli->prepare('UPDATE kullanicilar SET referans_kodu = ? WHERE id = ?');
        $stmt->bind_param('si', $code, $id);
        $stmt->execute();
        $stmt->close();
        $updated++;
    }
    echo "\nReferans kodu doldurulan kullanıcı sayısı: {$updated}\n";
}

echo "\nAffiliate migration tamamlandı.\n";

?>