<?php
session_start();

// Veritabanı bağlantısını yap
include 'database.php';

// Para çekme işlemleri için gerekli verileri al
$sql = "
    SELECT p.*, k.first_name, k.surname 
    FROM paracek p 
    JOIN kullanicilar k ON p.user_id = k.id
";
$result = $conn->query($sql);

$transactions = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $row['uye'] = $row['first_name'] . ' ' . $row['surname'];
        $transactions[] = $row;
    }
} else {
    $error = "Kayıt bulunamadı.";
}

// İşlem onayı kontrolü
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $transactionId = intval($_POST['id']);
    $action = $_POST['action'];

    // İşlem bilgilerini al
    $query = "SELECT * FROM paracek WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $transactionId);
    $stmt->execute();
    $transactionResult = $stmt->get_result();

    if ($transactionResult && $transactionResult->num_rows > 0) {
        $transaction = $transactionResult->fetch_assoc();

        // Kullanıcı bilgilerini al
        $userId = $transaction['user_id'];
        $miktar = $transaction['miktar'];

        if ($action === 'approve') {
           // Kullanıcı adını almak için sorgu
$userQuery = "SELECT first_name, surname FROM kullanicilar WHERE id = ?";
$userStmt = $conn->prepare($userQuery);
$userStmt->bind_param("i", $userId);
$userStmt->execute();
$userResult = $userStmt->get_result();

// Sorgudan dönen sonucu kontrol et
if ($userResult && $userResult->num_rows > 0) {
    $user = $userResult->fetch_assoc();
    $nameSurname = $user['first_name'] . ' ' . $user['surname'];
} else {
    $nameSurname = 'Bilinmiyor'; // Kullanıcı bulunamadığında
    // Hata mesajı ekleyelim
    error_log("Kullanıcı bulunamadı. user_id: " . $userId);
}

// Veriyi ekrana yazdıralım
echo "Ad Soyad: " . $nameSurname;


            // Firma anahtarını almak için firma tablosundan sorgu
            $firmaAd = $transaction['banka'];
            $firmaKeyQuery = "SELECT firma_key FROM firma WHERE firma_adi = ?";
            $firmaKeyStmt = $conn->prepare($firmaKeyQuery);
            $firmaKeyStmt->bind_param("s", $firmaAd);
            $firmaKeyStmt->execute();
            $firmaKeyResult = $firmaKeyStmt->get_result();

            if ($firmaKeyResult && $firmaKeyResult->num_rows > 0) {
                $firmaKeyData = $firmaKeyResult->fetch_assoc();
                $firmaKey = $firmaKeyData['firma_key'];
            } else {
                $firmaKey = ''; // Eğer firma adı yoksa
                $errorMessage = "Firma anahtarı bulunamadı.";
            }

            // İşlemi gerçekleştir
            $data = [
                "Process" => "Withdrawal",
                "firma_key" => $firmaKey,
                "UserID" => $userId,         // Kullanıcı ID
                "NameSurname" => $nameSurname, // Kullanıcı adı ve soyadı
                "BankName" => $transaction['banka'],
                "BankAccountNo" => $transaction['hesap'],
                "Amount" => $miktar,
                "Method" => $transaction['turi'],
                "Reference" => uniqid()    // Referans numarası
            ];

            // Gönderilen veriyi ekrana yazdır
            echo '<h3>Gönderilen Veri:</h3>';
            echo '<pre>';
            print_r($data);
            echo '</pre>';

            // API'ye POST isteği gönder
            $ch = curl_init('https://management.vevopay.com/api/veri');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
            ]);
            $response = curl_exec($ch);
            curl_close($ch);

            // API yanıtını kontrol et
            $responseData = json_decode($response, true);

            // API yanıtını ekrana yazdır
            echo '<h3>API Yanıtı:</h3>';
            echo '<pre>';
            print_r($responseData);
            echo '</pre>';

            if ($responseData && isset($responseData['apistatus']) && $responseData['apistatus'] === 'ok') {
                // Kullanıcı bakiyesini güncelle
                $updateUserBalance = "UPDATE kullanicilar SET ana_bakiye = ana_bakiye - ? WHERE id = ?";
                $updateStmt = $conn->prepare($updateUserBalance);
                $updateStmt->bind_param("di", $miktar, $userId);
                if ($updateStmt->execute()) {
                    // İşlemin durumunu güncelle
                    $updateTransaction = "UPDATE paracek SET durum = 1 WHERE id = ?";
                    $updateTransactionStmt = $conn->prepare($updateTransaction);
                    $updateTransactionStmt->bind_param("i", $transactionId);
                    $updateTransactionStmt->execute();

                    // Başarı mesajı
                    $successMessage = "İşlem Onaylandı!";
                } else {
                    $errorMessage = "Kullanıcı bakiyesi güncellenirken bir hata oluştu.";
                }
            } else {
                $errorMessage = "API'den geçersiz yanıt alındı.";
            }
        } elseif ($action === 'reject') {
            // Para çekme durumunu reddet
            $updateTransaction = "UPDATE paracek SET durum = 2 WHERE id = ?";
            $updateTransactionStmt = $conn->prepare($updateTransaction);
            $updateTransactionStmt->bind_param("i", $transactionId);
            $updateTransactionStmt->execute();

            // Başarı mesajı
            $successMessage = "Para çekme işlemi reddedildi.";
        } else {
            $errorMessage = "İşlem bulunamadı.";
        }
    } else {
        $errorMessage = "İşlem bulunamadı.";
    }
    $stmt->close();
}

$conn->close();
?>



<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Para Çekme İşlemleri</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">

</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>
            <div class="col-md-10 p-4">
    <div class="container">
        <h2>Para Çekme İşlemleri</h2>
        <?php if (isset($successMessage)): ?>
            <div class="message success"><?= $successMessage; ?></div>
        <?php elseif (isset($errorMessage)): ?>
            <div class="message error"><?= $errorMessage; ?></div>
        <?php endif; ?>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Kullanıcı</th>
                    <th>Banka</th>
                    <th>Miktar</th>
                    <th>Durum</th>
                    <th>İşlem</th>
                </tr>
            </thead>
<tbody>
    <?php foreach ($transactions as $transaction): ?>
        <tr>
            <td><?= $transaction['id']; ?></td>
            <td><?= $transaction['uye']; ?></td>
            <td><?= $transaction['banka']; ?></td>
            <td><?= $transaction['miktar']; ?></td>
            <td><?= $transaction['durum'] == 0 ? 'Beklemede' : ($transaction['durum'] == 1 ? 'Onaylandı' : 'Reddedildi'); ?></td>
            <td>
                <?php if ($transaction['durum'] == 0): // Durum 0 ise butonları göster ?>
                    <form method="post" action="">
                        <input type="hidden" name="id" value="<?= $transaction['id']; ?>">
                        <button type="submit" name="action" value="approve" class="btn btn-approve">Onayla</button>
                        <button type="submit" name="action" value="reject" class="btn btn-reject">Reddet</button>
                    </form>
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach; ?>
</tbody>

        </table>
    </div>
            </div>
        </div>
    </div>
</body>
</html>

    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: calc(100% - 10px); 
            max-width: 1600px; 
            margin: 5px auto; 
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 10px; 
            animation: fadeIn 0.5s ease-in-out;
            overflow-x: auto;
        }
        .container h2 {
            margin: 0 0 10px; 
            font-size: 18px; 
            color: #333;
        }
        table {
            width: 100%; 
            border-collapse: collapse;
            table-layout: auto; 
        }
        th, td {
            padding: 6px 10px; 
            text-align: left;
            border-bottom: 1px solid #ddd;
            word-wrap: break-word;
            font-size: 12px; 
        }
        th {
            background-color: #007bff;
            color: white;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .btn {
            display: inline-block;
            padding: 4px 8px; 
            font-size: 12px; 
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .btn-approve {
            background-color: #28a745;
        }
        .btn-approve:hover {
            background-color: #218838;
        }
        .btn-reject {
            background-color: #dc3545;
        }
        .btn-reject:hover {
            background-color: #c82333;
        }
        .message {
            margin: 10px 0;
            padding: 10px;
            border-radius: 4px;
        }
        .success {
            background-color: #28a745;
            color: white;
        }
        .error {
            background-color: #dc3545;
            color: white;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
