<?php
// Hata gösterme ayarları
ini_set('display_errors', 0); // Hataları kullanıcılara gösterme
ini_set('log_errors', 1); // Hataları günlüğe kaydet
error_reporting(E_ALL);

require 'config.php'; // Veritabanı bağlantısı
session_start();

// Promosyon ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {

    $action = $_POST['action'];

    // Kullanıcıdan gelen verileri al ve sanitize et
    $kod = filter_input(INPUT_POST, 'kod', FILTER_SANITIZE_STRING);
    $miktar = filter_input(INPUT_POST, 'miktar', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    $son_gecerlilik_tarihi = filter_input(INPUT_POST, 'son_gecerlilik_tarihi', FILTER_SANITIZE_STRING);
    $kullanim_limiti = filter_input(INPUT_POST, 'kullanim_limiti', FILTER_SANITIZE_NUMBER_INT);
    
    if ($action === 'ekle') {
        // Yeni promosyon ekleme
        $mevcut_kullanim = 0;

        $query = $pdo->prepare("INSERT INTO promosyonlar (kod, miktar, son_gecerlilik_tarihi, kullanim_limiti, mevcut_kullanim) VALUES (?, ?, ?, ?, ?)");
        $query->execute([$kod, $miktar, $son_gecerlilik_tarihi, $kullanim_limiti, $mevcut_kullanim]);

        echo "<script>Swal.fire('Başarılı!', 'Promosyon eklendi.', 'success');</script>";
    }

    if ($action === 'duzenle') {
        // Promosyon güncelleme
        $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

        $query = $pdo->prepare("UPDATE promosyonlar SET kod = ?, miktar = ?, son_gecerlilik_tarihi = ?, kullanim_limiti = ? WHERE id = ?");
        $query->execute([$kod, $miktar, $son_gecerlilik_tarihi, $kullanim_limiti, $id]);

        echo "<script>Swal.fire('Başarılı!', 'Promosyon güncellendi.', 'success');</script>";
    }

    if ($action === 'sil') {
        // Promosyon silme
        $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
        $query = $pdo->prepare("DELETE FROM promosyonlar WHERE id = ?");
        $query->execute([$id]);

        echo "<script>Swal.fire('Başarılı!', 'Promosyon silindi.', 'success');</script>";
    }
}

// Tüm promosyonları listele
$query = $pdo->query("SELECT * FROM promosyonlar ORDER BY miktar ASC");
$promosyonListesi = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Promosyonlar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<link rel="stylesheet" href="styles.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>
            <div class="col-md-10 p-4 mt-5">
                <h2 class="mb-4">Promosyonlar</h2>
                
                <!-- Promosyon Ekleme Formu -->
                <form method="POST" class="mb-4">
                    <input type="hidden" name="action" value="ekle">
                    
                    <div class="mb-3">
                        <label for="kod" class="form-label">Kod</label>
                        <input type="text" name="kod" id="kod" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="miktar" class="form-label">Miktar</label>
                        <input type="number" name="miktar" id="miktar" class="form-control" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label for="son_gecerlilik_tarihi" class="form-label">Son Geçerlilik Tarihi</label>
                        <input type="date" name="son_gecerlilik_tarihi" id="son_gecerlilik_tarihi" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="kullanim_limiti" class="form-label">Kullanım Limiti</label>
                        <input type="number" name="kullanim_limiti" id="kullanim_limiti" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Promosyon Ekle</button>
                </form>

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Kod</th>
                            <th>Miktar</th>
                            <th>Son Geçerlilik Tarihi</th>
                            <th>Kullanım Limiti</th>
                            <th>Mevcut Kullanım</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($promosyonListesi as $promosyon): ?>
                        <tr>
                            <td><?= htmlspecialchars($promosyon['id']) ?></td>
                            <td><?= htmlspecialchars($promosyon['kod']) ?></td>
                            <td><?= htmlspecialchars($promosyon['miktar']) ?></td>
                            <td><?= htmlspecialchars($promosyon['son_gecerlilik_tarihi']) ?></td>
                            <td><?= htmlspecialchars($promosyon['kullanim_limiti']) ?></td>
                            <td><?= htmlspecialchars($promosyon['mevcut_kullanim']) ?></td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                <strong>KOD: <?= htmlspecialchars($promosyon['kod']) ?> PROMOSYON</strong>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="action" value="duzenle">
                                    
                                    <input type="hidden" name="id" value="<?= htmlspecialchars($promosyon['id']) ?>">
                                    <input type="text" name="kod" value="<?= htmlspecialchars($promosyon['kod']) ?>" required>
                                    <input type="number" name="miktar" value="<?= htmlspecialchars($promosyon['miktar']) ?>" step="0.01" required>
                                    <input type="date" name="son_gecerlilik_tarihi" value="<?= htmlspecialchars($promosyon['son_gecerlilik_tarihi']) ?>" required>
                                    <input type="number" name="kullanim_limiti" value="<?= htmlspecialchars($promosyon['kullanim_limiti']) ?>" required>
                                    <button type="submit" class="btn btn-warning btn-sm">Düzenle</button>
                                </form>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="action" value="sil">
                                    
                                    <input type="hidden" name="id" value="<?= htmlspecialchars($promosyon['id']) ?>">
                                    <button type="submit" class="btn btn-danger btn-sm">Sil</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
