<?php include_once __DIR__ . '/auth.php'; ?>
<div class="col-md-2 sidebar text-white vh-100 d-flex flex-column p-3">
    <div class="sidebar-brand text-center">
        <span>BlackbetAdmin</span>
    </div>

    <!-- Genel -->
    <div class="sidebar-section" data-section="genel">
        <div class="sidebar-section-header">
            <span class="label">Genel</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('dashboard_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='dashboard.php' ? 'active' : 'text-white'; ?>" href="dashboard.php">
                        <i class="fas fa-tachometer-alt"></i> Dashboard
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('analytics_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='system.php' ? 'active' : 'text-white'; ?>" href="system.php">
                        <i class="fas fa-cogs"></i> Sistem Sağlığı
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Analitik ve Log -->
    <div class="sidebar-section" data-section="analitik">
        <div class="sidebar-section-header">
            <span class="label">Analitik & Log</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('analytics_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='stats.php' ? 'active' : 'text-white'; ?>" href="stats.php">
                        <i class="fas fa-chart-line"></i> Site İstatistikleri
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='reports.php' ? 'active' : 'text-white'; ?>" href="reports.php">
                        <i class="fas fa-chart-pie"></i> Raporlar
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='logs_viewer.php' ? 'active' : 'text-white'; ?>" href="logs_viewer.php">
                        <i class="fas fa-clipboard-list"></i> Loglar
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('analytics_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='trigger_monitoring.php' ? 'active' : 'text-white'; ?>" href="trigger_monitoring.php">
                        <i class="fas fa-bell"></i> Tetikleyici İzleme
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Turnuvalar ve Etkinlikler -->
    <div class="sidebar-section" data-section="turnuvalar">
        <div class="sidebar-section-header">
            <span class="label">Turnuvalar & Etkinlikler</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('tournaments_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='tournaments.php' ? 'active' : 'text-white'; ?>" href="tournaments.php">
                        <i class="fas fa-trophy"></i> Turnuva Yönetimi
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('events_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='seasonal_events.php' ? 'active' : 'text-white'; ?>" href="seasonal_events.php">
                        <i class="fas fa-calendar-alt"></i> Mevsimsel Etkinlikler
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('bonuses_manage')): ?>
                    <li class="nav-item mb-2">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='bonuses.php' ? 'active' : 'text-white'; ?>" href="bonuses.php">
                            <i class="fas fa-gift"></i> Bonus Yönetimi
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (has_permission('bonuses_manage')): ?>
                    <li class="nav-item mb-2">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='cashback.php' ? 'active' : 'text-white'; ?>" href="cashback.php">
                            <i class="fas fa-money-bill-wave"></i> Cashback Programları
                        </a>
                    </li>
                    <?php endif; ?>

                <?php if (has_permission('loyalty_manage')): ?>
                    <li class="nav-item mb-2">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='loyalty_management.php' ? 'active' : 'text-white'; ?>" href="loyalty_management.php">
                            <i class="fas fa-star"></i> Sadakat Programı
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (has_permission('games_manage')): ?>
                    <li class="nav-item mb-2">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='mini_games.php' ? 'active' : 'text-white'; ?>" href="mini_games.php">
                            <i class="fas fa-gamepad"></i> Mini Oyunlar
                        </a>
                    </li>
                    <?php endif; ?>
                    
            </ul>
        </div>
    </div>

    <!-- Kullanıcılar -->
    <div class="sidebar-section" data-section="kullanicilar">
        <div class="sidebar-section-header">
            <span class="label">Kullanıcılar</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('users_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='users.php' ? 'active' : 'text-white'; ?>" href="users.php">
                        <i class="fas fa-users"></i> Kullanıcılar
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('users_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='kyc.php' ? 'active' : 'text-white'; ?>" href="kyc.php">
                        <i class="fas fa-id-card"></i> KYC İnceleme
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('users_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='session_management.php' ? 'active' : 'text-white'; ?>" href="session_management.php">
                        <i class="fas fa-shield-alt"></i> Oturum Yönetimi
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('users_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='suspicious_alerts.php' ? 'active' : 'text-white'; ?>" href="suspicious_alerts.php">
                        <i class="fas fa-exclamation-triangle"></i> Şüpheli Aktivite Uyarıları
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Finans -->
    <div class="sidebar-section" data-section="finans">
        <div class="sidebar-section-header">
            <span class="label">Finans</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('deposit_review')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='parayatir.php' ? 'active' : 'text-white'; ?>" href="parayatir.php">
                        <i class="fas fa-wallet"></i> Para Yatırma
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('withdraw_review')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='paracek.php' ? 'active' : 'text-white'; ?>" href="paracek.php">
                        <i class="fas fa-hand-holding-usd"></i> Para Çekme
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('banks_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='payment_methods.php' ? 'active' : 'text-white'; ?>" href="payment_methods.php">
                        <i class="fas fa-credit-card"></i> Ödeme Yöntemleri
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- İçerik ve Oyun -->
    <div class="sidebar-section" data-section="icerik">
        <div class="sidebar-section-header">
            <span class="label">İçerik & Oyun</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='bonus_management.php' ? 'active' : 'text-white'; ?>" href="bonus_management.php">
                        <i class="fas fa-gift"></i> Bonus Yönetimi
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='loyalty_management.php' ? 'active' : 'text-white'; ?>" href="loyalty_management.php">
                        <i class="fas fa-trophy"></i> Sadakat Programı
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='tournament_management.php' ? 'active' : 'text-white'; ?>" href="tournament_management.php">
                        <i class="fas fa-trophy"></i> Turnuva Yönetimi
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='promosyonlar.php' ? 'active' : 'text-white'; ?>" href="promosyonlar.php">
                        <i class="fas fa-bullhorn"></i> Promosyonlar
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='promosyon_ekle.php' ? 'active' : 'text-white'; ?>" href="promosyon_ekle.php">
                        <i class="fas fa-plus-circle"></i> Promosyon Ekle
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='slider.php' ? 'active' : 'text-white'; ?>" href="slider.php">
                        <i class="fas fa-sliders-h"></i> Slider Düzenle
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('games_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='games.php' ? 'active' : 'text-white'; ?>" href="games.php">
                        <i class="fas fa-gamepad"></i> Oyunları Düzenle
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('games_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='games_fetch.php' ? 'active' : 'text-white'; ?>" href="games_fetch.php">
                        <i class="bi bi-download"></i> Oyun Çek
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('content_manage')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='firma.php' ? 'active' : 'text-white'; ?>" href="firma.php">
                        <i class="fas fa-building"></i> Firma Kodları
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Geçmiş ve Referans -->
    <div class="sidebar-section" data-section="gecmis">
        <div class="sidebar-section-header">
            <span class="label">Geçmiş & Referans</span>
            <span class="chev">▾</span>
        </div>
        <div class="sidebar-section-body">
            <ul class="nav flex-column mt-2">
                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='gecmis.php' ? 'active' : 'text-white'; ?>" href="gecmis.php">
                        <i class="fas fa-history"></i> Casino Geçmişi
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='bahis.php' ? 'active' : 'text-white'; ?>" href="bahis.php">
                        <i class="fas fa-file-alt"></i> Bahis Geçmişi
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='referrals.php' ? 'active' : 'text-white'; ?>" href="referrals.php">
                        <i class="bi bi-diagram-3"></i> Referans Raporları
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo in_array(basename($_SERVER['PHP_SELF']), ['aff.php','affbasvur.php']) ? 'active' : 'text-white'; ?>" href="aff.php">
                        <i class="bi bi-person-check"></i> Affiliate Kullanıcıları
                    </a>
                </li>
                <?php endif; ?>

                <?php if (has_permission('reports_view')): ?>
                <li class="nav-item mb-2">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF'])==='affbasvur.php' ? 'active' : 'text-white'; ?>" href="affbasvur.php">
                        <i class="bi bi-person-check"></i> Affiliate Basvuruları
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Çıkış -->
    <div class="mt-auto">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link text-danger" href="logout.php">
                    <i class="bi bi-box-arrow-right"></i> Çıkış Yap
                </a>
            </li>
        </ul>
    </div>
</div>

<!-- FontAwesome İkonlar için Bağlantı -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
