<?php
include 'config.php'; // Veritabanı bağlantısını ekleyin

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Silinecek görselin ID'sini al
    $id = $_POST['id'];

    // Veritabanından silme işlemi
    try {
        $stmt = $pdo->prepare("DELETE FROM gorseller WHERE id = :id");
        $stmt->bindParam(':id', $id);

        if ($stmt->execute()) {
            // Başarılı silme işlemi sonrası yönlendirme
            header("Location: slider.php?delete_success=1");
            exit();
        } else {
            // Hata durumunda yönlendirme
            header("Location: slider.php?delete_error=1");
            exit();
        }
    } catch (PDOException $e) {
        // Hata durumunda yönlendirme
        header("Location: slider.php?delete_error=1");
        exit();
    }
} else {
    // Eğer istek POST değilse, geri yönlendirme
    header("Location: slider.php");
    exit();
}
?>
