<?php
include 'config.php'; // Veritabanı bağlantısını ekleyin
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit;
}

// Görselleri çek
$stmt = $pdo->query("SELECT * FROM gorseller");
$gorseller = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"> <!-- Mobil uyumluluk için ekleme -->
    <title>Slider Görsel Düzenle</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css"> <!-- Font Awesome -->
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar'ı dahil et -->
            <?php include 'sidebar.php'; ?>

            <div class="col-md-10 p-4">
                <h2 class="mt-4">Slider Görsel Düzenle</h2>

                <!-- Slider görsellerini listeleme -->
                <div class="slider-list mb-4">
                    <div class="row">
                        <?php foreach ($gorseller as $gorsel): ?>
                            <div class="col-md-4 col-sm-6 mb-3">
                                <div class="slider-item text-center">
                                    <img src="<?php echo $gorsel['url']; ?>" alt="<?php echo $gorsel['alt_text']; ?>" class="img-fluid img-thumbnail" style="width: 100%; height: auto;">
                                    <p class="mb-1"><?php echo $gorsel['alt_text']; ?></p>
                                    <!-- Silme butonu -->
                                    <form action="sil.php" method="post">
                                        <input type="hidden" name="id" value="<?php echo $gorsel['id']; ?>">
                                        <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash-alt"></i> Sil</button>
                                    </form>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Yeni görsel ekleme formu -->
                <h3>Yeni Görsel Ekle</h3>
                <form action="ekle.php" method="post" class="mb-4">
                    <div class="form-group">
                        <label for="url">Görsel URL'si</label>
                        <input type="text" name="url" id="url" class="form-control" placeholder="Görsel URL'si" required>
                    </div>
                    <div class="form-group">
                        <label for="alt_text">Görsel Açıklaması</label>
                        <input type="text" name="alt_text" id="alt_text" class="form-control" placeholder="Görsel Açıklaması" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Ekle</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS (Bundle) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
