<?php
session_start();
require_once __DIR__ . '/auth.php';
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site İstatistikleri</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .stat-value { font-size: 1.8rem; font-weight: 600; }
        .muted { color: #9aa0a6; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/sidebar.php'; ?>

            <div class="col-md-10 p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <h1>Site İstatistikleri</h1>
                        <p class="text-muted">Gerçek zamanlı sahte verilerle genel görünüm. İstediğinde yenile.</p>
                    </div>
                    <div class="d-flex gap-2">
                        <button id="refreshBtn" class="btn btn-primary">Yenile</button>
                        <span id="lastUpdated" class="muted"></span>
                    </div>
                </div>

                <!-- Üst Kartlar -->
                <div class="row mt-3">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Toplam Kullanıcı</h5>
                                <div id="totalUsers" class="stat-value">-</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Aktif Kullanıcı</h5>
                                <div id="activeUsers" class="stat-value">-</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Bugünkü Bahis Toplamı</h5>
                                <div id="todayBets" class="stat-value">-</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Toplam Yatırım</h5>
                                <div id="totalDeposits" class="stat-value">-</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Toplam Ödeme</h5>
                                <div id="totalPayout" class="stat-value">-</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Son Kazananlar -->
                <div class="card mt-4">
                    <div class="card-body">
                        <h5 class="card-title">Son Kazananlar</h5>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped" id="winnersTable">
                                <thead>
                                    <tr>
                                        <th>Kullanıcı</th>
                                        <th>Kazanç</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function formatCurrency(n){
            return new Intl.NumberFormat('tr-TR').format(n) + ' ₺';
        }
        function formatNumber(n){
            return new Intl.NumberFormat('tr-TR').format(n);
        }

        function renderStats(s){
            $('#totalUsers').text(formatNumber(s.total_users));
            $('#activeUsers').text(formatNumber(s.active_users));
            $('#todayBets').text(formatCurrency(s.today_bets));
            $('#totalDeposits').text(formatCurrency(s.total_deposits));
            $('#totalPayout').text(formatCurrency(s.total_payout));

            const $tbody = $('#winnersTable tbody');
            $tbody.empty();
            s.recent_winners.forEach(function(w){
                const tr = `<tr>
                    <td>${w.kullanici_adi}</td>
                    <td>${formatCurrency(w.kazanc)}</td>
                    <td>${w.tarih}</td>
                </tr>`;
                $tbody.append(tr);
            });
        }

        function loadStats(){
            $.ajax({
                url: '../inc/site_stats.php?action=get_stats',
                dataType: 'json',
                cache: false,
                timeout: 8000
            }).done(function(s){
                renderStats(s);
                const d = new Date();
                $('#lastUpdated').text('Son güncelleme: ' + d.toLocaleTimeString('tr-TR'));
            }).fail(function(_xhr, status){
                $('#lastUpdated').text('İstatistikler yüklenemedi (' + status + '). Tekrar denenecek...');
            });
        }

        $('#refreshBtn').on('click', loadStats);
        loadStats();
        setInterval(loadStats, 60000); // 60sn otomatik yenile
    </script>
</body>
</html>