<?php
session_start();
require_once __DIR__ . '/auth.php';
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$phpVersion = phpversion();
$extensions = get_loaded_extensions();
$paths = [
    'woohdd' => __DIR__,
    'inc/error.log' => realpath(__DIR__ . '/../inc/error.log') ?: (__DIR__ . '/../inc/error.log'),
    'profile/uploads' => realpath(__DIR__ . '/../profile/uploads') ?: (__DIR__ . '/../profile/uploads'),
];

$dbStatus = ['ok' => false, 'message' => ''];
try {
    require_once __DIR__ . '/database.php';
    if (isset($pdo)) {
        $pdo->query('SELECT 1');
        $dbStatus['ok'] = true;
        $dbStatus['message'] = 'Veritabanı bağlantısı başarılı.';
    } else {
        $dbStatus['message'] = 'Veritabanı bağlantı nesnesi bulunamadı.';
    }
} catch (Throwable $e) {
    $dbStatus['message'] = 'Veritabanı bağlantısı başarısız: ' . $e->getMessage();
}

if (isset($_GET['phpinfo'])) {
    phpinfo();
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Sağlığı</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
    <style>
        .status-ok { color: #00c957; }
        .status-fail { color: #ff3b3b; }
        .card-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 12px; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/sidebar.php'; ?>

            <div class="col-md-10 p-4">
                <?php include __DIR__ . '/topbar.php'; ?>
                <h1>Sistem Sağlığı</h1>
                <p class="text-muted">Sunucu, PHP ve veritabanı durumunu görüntüleyin.</p>

                <div class="card-grid mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">PHP Sürümü</h5>
                            <p><?= htmlspecialchars($phpVersion) ?></p>
                            <a class="btn btn-secondary" href="system.php?phpinfo=1" target="_blank">phpinfo()</a>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Veritabanı</h5>
                            <p class="<?= $dbStatus['ok'] ? 'status-ok' : 'status-fail' ?>"><?= htmlspecialchars($dbStatus['message']) ?></p>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title">Yüklü PHP Eklentileri (ilk 30)</h5>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped">
                                <thead><tr><th>#</th><th>Eklenti</th></tr></thead>
                                <tbody>
                                    <?php foreach (array_slice($extensions, 0, 30) as $i => $ext): ?>
                                    <tr><td><?= $i+1 ?></td><td><?= htmlspecialchars($ext) ?></td></tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Yol ve İzin Kontrolleri</h5>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped">
                                <thead><tr><th>Kaynak</th><th>Yol</th><th>Mevcut</th><th>Yazılabilir</th></tr></thead>
                                <tbody>
                                    <?php foreach ($paths as $name => $path): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($name) ?></td>
                                        <td><?= htmlspecialchars($path) ?></td>
                                        <td><?= file_exists($path) ? '<span class="status-ok">Var</span>' : '<span class="status-fail">Yok</span>' ?></td>
                                        <td><?= is_writable($path) ? '<span class="status-ok">Yazılabilir</span>' : '<span class="status-fail">Yazılamaz</span>' ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</body>
</html>
<script src="admin.js"></script>