<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$adminUser = $_SESSION['admin_user'] ?? 'Admin';
$adminRole = $_SESSION['admin_role'] ?? '';
// Basit sayfa başlıkları için breadcrumb
$pageMap = [
  'dashboard.php' => 'Dashboard',
  'users.php' => 'Kullanıcılar',
  'reports.php' => 'Raporlar',
  'system.php' => 'Sistem Sağlığı',
  'kyc.php' => 'KYC İnceleme',
  'referrals.php' => 'Referans Raporları',
  'aff.php' => 'Affiliate Kullanıcıları',
];
$current = basename($_SERVER['PHP_SELF']);
$currentTitle = $pageMap[$current] ?? 'Panel';
?>
<div class="d-flex align-items-center justify-content-between mb-3" style="position: sticky; top: 0; z-index: 1020; background: rgba(19,20,23,0.85); backdrop-filter: blur(6px); border: 1px solid var(--border); border-radius: 12px; padding: 8px 12px;">
  <div class="d-flex align-items-center gap-2">
    <button id="sidebarToggle" class="btn btn-outline-secondary" title="Menüyü Aç/Kapat">
      <i class="bi bi-list"></i>
    </button>
    <span class="fw-bold" style="color: var(--primary);">Yönetim Paneli</span>
    <span class="text-muted">/ <?php echo htmlspecialchars($currentTitle); ?></span>
  </div>
  <div class="d-flex align-items-center gap-3">
    <form class="d-none d-md-flex" method="GET" action="users.php" style="gap:6px;">
      <input type="text" id="globalQuickSearch" name="quick" class="form-control form-control-sm" placeholder="Hızlı Arama (kullanıcı/ID)">
      <button class="btn btn-sm btn-primary" type="submit">Ara</button>
    </form>
    <span class="text-muted">Kullanıcı: <?php echo htmlspecialchars($adminUser); ?><?php echo $adminRole ? ' · ' . htmlspecialchars($adminRole) : ''; ?></span>
    <a class="btn btn-sm btn-outline-light" href="dashboard.php">Dashboard</a>
    <a class="btn btn-sm btn-outline-light" href="users.php">Kullanıcılar</a>
    <a class="btn btn-sm btn-outline-light" href="reports.php">Raporlar</a>
    <button class="btn btn-sm btn-outline-secondary" title="Kısayollar" data-bs-toggle="modal" data-bs-target="#shortcutsModal"><i class="bi bi-question-circle"></i></button>
    <button class="btn btn-sm btn-outline-secondary" id="themeToggle" title="Tema"><i class="bi bi-brightness-high"></i></button>
  </div>
</div>

<!-- Kısayollar Yardım Modal -->
<div class="modal fade" id="shortcutsModal" tabindex="-1" aria-labelledby="shortcutsModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="shortcutsModalLabel">Klavye Kısayolları</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <ul>
          <li><strong>Ctrl + B</strong>: Sidebar aç/kapat</li>
          <li><strong>Ctrl + /</strong>: Global arama alanına odaklan</li>
          <li><strong>g ardından u</strong>: Kullanıcılar</li>
          <li><strong>g ardından r</strong>: Raporlar</li>
          <li><strong>g ardından f</strong>: Referans Raporları</li>
          <li><strong>g ardından l</strong>: Log Görüntüleyici</li>
          <li><strong>Shift + ?</strong>: Bu yardım penceresini aç</li>
        </ul>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
      </div>
    </div>
  </div>
  </div>