<?php
session_start();

// Yalnızca admin oturumu açıkken erişime izin ver
if (!isset($_SESSION['admin_logged_in'])) {
    http_response_code(401);
    echo "Unauthorized";
    exit;
}

require_once __DIR__ . '/dblive.php';

try {
    $pdo = new PDO("mysql:host=$user_db_servername;dbname=$user_db_name;charset=utf8", $user_db_username, $user_db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo "Veritabanına bağlanılamadı: " . htmlspecialchars($e->getMessage());
    exit;
}

// İzin verilen durumlar
$allowed_statuses = ['Beklemede', 'Onaylandı', 'Reddedildi'];

// POST verilerini al ve doğrula
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$status = isset($_POST['status']) ? trim($_POST['status']) : '';

if ($id <= 0) {
    http_response_code(400);
    echo "Geçersiz ID";
    exit;
}

if (!in_array($status, $allowed_statuses, true)) {
    http_response_code(400);
    echo "Geçersiz durum";
    exit;
}

try {
    $stmt = $pdo->prepare("UPDATE affiliate_applications SET status = :status WHERE id = :id");
    $stmt->bindParam(':status', $status, PDO::PARAM_STR);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    echo "OK";
} catch (PDOException $e) {
    http_response_code(500);
    echo "Güncelleme hatası: " . htmlspecialchars($e->getMessage());
}