<?php
session_start();
include 'config.php';

// Admin giriş kontrolü
if (!isset($_SESSION['admin_logged_in'])) {
    echo json_encode(['success' => false, 'message' => 'Yetkilendirme hatası. Lütfen giriş yapın.']);
    exit;
}

// POST verilerini kontrol et
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Gerekli alanları al
    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
    $provider_id = trim($_POST['provider_id'] ?? '');
    $game_id = trim($_POST['game_id'] ?? '');
    $game_code = trim($_POST['game_code'] ?? '');
    $game_type = trim($_POST['game_type'] ?? '');
    $cover = trim($_POST['cover'] ?? '');
    $provider_game = trim($_POST['provider_game'] ?? '');
    $banner = trim($_POST['banner'] ?? '');

    // Girdi doğrulaması
    if (!$id || !$provider_id || !$game_id || !$game_code || !$game_type || !$cover || !$provider_game || !$banner) {
        echo json_encode(['success' => false, 'message' => 'Eksik veya geçersiz veri girdiniz.']);
        exit;
    }

    try {
        // Veritabanında güncelleme işlemi
        $stmt = $pdo->prepare("
            UPDATE games 
            SET 
                provider_id = :provider_id,
                game_id = :game_id,
                game_code = :game_code,
                game_type = :game_type,
                cover = :cover,
                provider_game = :provider_game,
                banner = :banner
            WHERE id = :id
        ");

        $stmt->bindParam(':provider_id', $provider_id);
        $stmt->bindParam(':game_id', $game_id);
        $stmt->bindParam(':game_code', $game_code);
        $stmt->bindParam(':game_type', $game_type);
        $stmt->bindParam(':cover', $cover);
        $stmt->bindParam(':provider_game', $provider_game);
        $stmt->bindParam(':banner', $banner);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Oyun başarıyla güncellendi.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Veritabanı hatası: Güncelleme başarısız.']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek yöntemi.']);
}
