<?php
session_start();
header('Content-Type: text/plain; charset=utf-8');

// Yalnızca admin girişliyken işlem yapılmasına izin ver
if (!isset($_SESSION['admin_logged_in'])) {
    http_response_code(401);
    echo 'Unauthorized';
    exit;
}

// DB kimlik bilgilerini al
include 'dblive.php';

try {
    $pdo = new PDO("mysql:host=$user_db_servername;dbname=$user_db_name;charset=utf8", $user_db_username, $user_db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo 'DB connect error: ' . htmlspecialchars($e->getMessage());
    exit;
}

// Girdi doğrulama
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$durum = isset($_POST['durum']) ? trim($_POST['durum']) : '';
$allowed = ['Beklemede', 'Onaylandı', 'Reddedildi'];

if ($id <= 0 || !in_array($durum, $allowed, true)) {
    http_response_code(200);
    echo 'No change';
    exit;
}

try {
    $stmt = $pdo->prepare('UPDATE kullanici2 SET durum = :durum, updated_at = NOW() WHERE id = :id');
    $stmt->execute([':durum' => $durum, ':id' => $id]);

    // Her durumda 200 döndür, istemci tarafı mesajı yönetiyor
    http_response_code(200);
    echo 'OK';
} catch (PDOException $e) {
    http_response_code(500);
    echo 'DB error: ' . htmlspecialchars($e->getMessage());
}