<?php
ob_start();
session_start();
date_default_timezone_set('Europe/Istanbul');

// Veritabanı bilgileri
$servername = "localhost";
$db_user = "blacrhdy_bet1";
$db_pass = "blacrhdy_bet1";
$dbname = "blacrhdy_bet1";

// Kullanıcı bilgileri
$isLoggedIn = isset($_SESSION['loggedin']) && $_SESSION['loggedin'];
$userUsername = $isLoggedIn ? $_SESSION['username'] : '';

// Veritabanı bağlantısı
$conn = new mysqli($servername, $db_user, $db_pass, $dbname);
if ($conn->connect_error) exit;

// Kullanıcı bakiyesi ve ID
$userBalance = null;
$users_id = null;

if ($isLoggedIn && !empty($userUsername)) {
    $stmt = $conn->prepare("SELECT id, ana_bakiye FROM kullanicilar WHERE username = ?");
    $stmt->bind_param("s", $userUsername);
    $stmt->execute();
    $stmt->bind_result($users_id_db, $userBalance_db);
    if ($stmt->fetch()) {
        $users_id = $users_id_db;
        $userBalance = $userBalance_db;
    }
    $stmt->close();
}

// Session'a bakiyeyi kaydet
$_SESSION['ana_bakiye'] = $userBalance;

// Eğer kullanıcı giriş yapmamışsa guest ID oluştur
if (empty($users_id)) {
    $users_id = "guest_" . rand(1000,9999); // örnek guest ID
}

$conn->close();

// -------- Veritral Oyun Başlatma --------
class AgentGameExample {
    private $api_key = 'api_68df7464c7bc9_9aae3eaa0228a0a7';
    private $secret_key = 'secret_13ea3a59fc49f44584caab9e40ad3971';
    private $base_url = 'https://api.veritral.com/api/v2/launch';

    public function startGame($game_id, $username, $player_id) {
        $data = [
            'api_key'    => $this->api_key,
            'secret_key' => $this->secret_key,
            'mode'       => 'sports',
            'username'   => $username ?: $player_id,
            'player_id'  => $player_id,
            'game_id'    => $game_id,
            'currency'   => 'TRY',
            'language'   => 'tur'
        ];

        $response = $this->makeRequest($data);

        if (isset($response['status']) && $response['status'] === 'success') {
            return $response['data']['launch_url'];
        } else {
            return ''; // hata durumunda boş URL
        }
    }

    private function makeRequest($data) {
        $ch = curl_init($this->base_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
}

// Oyun başlat
$agent = new AgentGameExample();
$game_url = $agent->startGame("2", $userUsername, $users_id);
?>

<html lang="tr" class="browser-Chrome" style="--vh: 9.450000000000001px;">

<head>
    <meta charset="utf-8">
    <title data-rh="true"></title>



    <meta name="viewport" content="width=device-width, maximum-scale=1, viewport-fit=cover">


    <link data-chunk="main" rel="stylesheet" href="/sporassets/main.15203e0c84ea961ee027.css">
    <link data-chunk="theme" rel="stylesheet" href="/sporassets/theme.3ed7d24f26ca4b2477c4.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/3.5ea1511a7cce485e81ae.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/0.38c1ac79ecf1be31d551.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/2.604450a90727135839a1.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/1.b3fcf877461209e39ccd.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/6.3b5480dc1d9cd739b966.css">

    <!-- Env variables -->

    <!-- End Env variables-->
    <link rel="stylesheet" type="text/css" href="/sporassets/13.ca7386153f0814e7c5d8.css">
    <script charset="utf-8" src="/sporassets/13.8612bbd3e0340393cd4c.js"></script>
    <link rel="stylesheet" type="text/css" href="/sporassets/7.10632a04adb21a618427.css">
    <script charset="utf-8" src="/sporassets/7.2248abf3440d4330b8d4.js"></script>
</head>

<body class="">
<script>
(function(){
  function setVH(){
    var vh = window.innerHeight * 0.01;
    document.documentElement.style.setProperty('--vh', vh + 'px');
  }
  setVH();
  window.addEventListener('resize', setVH);
  window.addEventListener('orientationchange', setVH);
  window.addEventListener('pageshow', setVH);
})();
</script>

<?php

?>

<style>
.dark-loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: calc(var(--vh, 1vh) * 100);
    background: #111111;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

.loader-content {
    text-align: center;
}

.spinner-box {
    width: 80px;
    height: 80px;
    margin: 0 auto 20px;
    position: relative;
}

.spinner {
    width: 100%;
    height: 100%;
    border: 4px solid #1a1a1a;
    border-top: 4px solid #ff1a1a;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

.loader-text {
    color: #ff1a1a;
    font-family: Arial, sans-serif;
    font-size: 18px;
    letter-spacing: 4px;
    animation: pulse 1.5s ease-in-out infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

html, body {
    height: 100%;
    margin: 0;
    padding: 0;
    background: #000;
}

/* Global renk override: kırmızıyı sarıya çevir */
:root {
    --danger: #fed700;
}

.game-container {
    position: relative;
    width: 100%;
    height: calc(var(--vh, 1vh) * 100); /* Tam ekran yükseklik - dinamik */
    margin: 0; /* Siyah boşlukları kaldır */
    background: transparent; /* Arka planı kaldır */
    overflow: hidden;
    z-index: 99;
    border-radius: 0; /* Köşe yuvarlama kaldır */
    box-shadow: none; /* Gölge kaldır */
}

.game-container iframe {
    width: 100%;
    height: 100%;
    border: none; /* Kenarlığı kaldır */
    margin: 0;
    padding: 0;
    display: block;
    border-radius: 0;
    background: transparent; /* Arka planı kaldır */
}

/* Olası oran seçim durumlarını sarı yap (geniş kapsamlı override) */
.odds-cell.is-selected,
.odds-cell.selected,
.odds-cell.active,
.odd.is-selected,
.odd.selected,
.odd.active,
.betting-table-row .odds-cell.is-selected,
.betting-table-row .odds-cell.selected,
.betting-table-row .odds-cell.active,
.btn-danger,
.button-danger {
    background-color: #fed700 !important;
    border-color: #fed700 !important;
    color: #000 !important;
}

@media (max-width: 768px) {
    .game-container {
        height: calc(var(--vh, 1vh) * 100);
        margin: 0;
    }
}

/* Spor sayfası üst boşluğu kaldıran override'lar */
.header-main-sticky { display: none !important; height: 0 !important; }
.header-main { height: 0 !important; padding: 0 !important; }
.sports-menu { padding-top: 0 !important; }
.central-part { margin-top: 0 !important; padding-top: 0 !important; }
.list-of-games { margin-top: 0 !important; padding-top: 0 !important; }
</style>

<div class="dark-loader" id="loadingScreen">
    <div class="loader-content">
        <div class="spinner-box">
            <div class="spinner"></div>
        </div>
        <div class="loader-text" data-i18n="spor_yukleniyor">Yükleniyor</div>
    </div>
</div>

<div id="gameContent" style="display: none;">
    <div class="game-container">
        <iframe 
            src="<?php echo htmlspecialchars($game_url); ?>"
            id="gameFrame"
            allow="fullscreen; autoplay; clipboard-write; encrypted-media"
            sandbox="allow-same-origin allow-scripts allow-popups allow-forms allow-top-navigation"
            referrerpolicy="no-referrer"
            allowfullscreen
        ></iframe>
    </div>
</div>


<script>
window.addEventListener("load", function () {
    const loader = document.getElementById("loadingScreen");
    const content = document.getElementById("gameContent");
    const gameFrame = document.getElementById("gameFrame");

    let isLoaded = false;

    gameFrame.addEventListener("load", function() {
        isLoaded = true;
        hideLoader();
    });

    function checkIframeContent() {
        try {
            if (gameFrame.contentWindow.document.readyState === 'complete') {
                isLoaded = true;
                hideLoader();
            }
        } catch(e) {}

    }

    const checkInterval = setInterval(() => {
        if (isLoaded) {
            clearInterval(checkInterval);
            return;
        }
        checkIframeContent();
    }, 500);

    function hideLoader() {
        loader.style.transition = "opacity 0.8s ease-out";
        loader.style.opacity = "0";
        content.style.display = "block";
        
        setTimeout(() => {
            loader.style.display = "none";
        }, 800);
    }

    setTimeout(() => {
        if (!isLoaded) {
            hideLoader();
            clearInterval(checkInterval);
        }
    }, 1000);
});
</script>

<?php require_once 'footer.php'; ?>

                                                </div>
                                              
            
            
            






</body>

</html>